/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.BasicDuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DefaultDuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.UniversalPromptDuoSecurityAuthenticationService;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderFactoryBean;
import org.apereo.cas.authentication.bypass.ChainingMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.util.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuoSecurityMultifactorAuthenticationProviderFactory
implements MultifactorAuthenticationProviderFactoryBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityMultifactorAuthenticationProviderFactory.class);
    private static final int USER_ACCOUNT_CACHE_INITIAL_SIZE = 50;
    private static final long USER_ACCOUNT_CACHE_MAX_SIZE = 1000L;
    private static final int USER_ACCOUNT_CACHE_EXPIRATION_SECONDS = 5;
    private final HttpClient httpClient;
    private final ChainingMultifactorAuthenticationProviderBypassEvaluator bypassEvaluator;
    private final MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator;
    private final CasConfigurationProperties casProperties;
    private final List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolvers;

    public DuoSecurityMultifactorAuthenticationProvider createProvider(DuoSecurityMultifactorAuthenticationProperties properties) {
        DefaultDuoSecurityMultifactorAuthenticationProvider provider = new DefaultDuoSecurityMultifactorAuthenticationProvider();
        provider.setRegistrationUrl(properties.getRegistrationUrl());
        provider.setDuoAuthenticationService(this.getDuoAuthenticationService(properties));
        provider.setFailureMode(properties.getFailureMode());
        provider.setFailureModeEvaluator(this.failureModeEvaluator);
        provider.setBypassEvaluator(this.getMultifactorAuthenticationProviderBypass(properties));
        provider.setOrder(properties.getRank());
        provider.setId(properties.getId());
        return provider;
    }

    protected MultifactorAuthenticationProviderBypassEvaluator getMultifactorAuthenticationProviderBypass(DuoSecurityMultifactorAuthenticationProperties properties) {
        return this.bypassEvaluator.filterMultifactorAuthenticationProviderBypassEvaluatorsBy(properties.getId());
    }

    protected DuoSecurityAuthenticationService getDuoAuthenticationService(DuoSecurityMultifactorAuthenticationProperties properties) {
        Cache cache = Caffeine.newBuilder().initialCapacity(50).maximumSize(1000L).expireAfterWrite(Duration.ofSeconds(5L)).build();
        if (StringUtils.isBlank((CharSequence)properties.getDuoApplicationKey())) {
            LOGGER.trace("Activating universal prompt authentication service for duo security");
            return new UniversalPromptDuoSecurityAuthenticationService(properties, this.httpClient, this.casProperties, this.multifactorAuthenticationPrincipalResolvers, (Cache<String, DuoSecurityUserAccount>)cache);
        }
        return new BasicDuoSecurityAuthenticationService(properties, this.httpClient, this.multifactorAuthenticationPrincipalResolvers, (Cache<String, DuoSecurityUserAccount>)cache);
    }

    @Generated
    public DuoSecurityMultifactorAuthenticationProviderFactory(HttpClient httpClient, ChainingMultifactorAuthenticationProviderBypassEvaluator bypassEvaluator, MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, CasConfigurationProperties casProperties, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolvers) {
        this.httpClient = httpClient;
        this.bypassEvaluator = bypassEvaluator;
        this.failureModeEvaluator = failureModeEvaluator;
        this.casProperties = casProperties;
        this.multifactorAuthenticationPrincipalResolvers = multifactorAuthenticationPrincipalResolvers;
    }
}

