/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FetchTicketGrantingTicketAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchTicketGrantingTicketAction.class);
    private final TicketRegistry ticketRegistry;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String cookie = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        Optional.ofNullable(cookie).ifPresent(c -> {
            LOGGER.debug("Attempting to locate ticket-granting ticket from cookie value [{}]", (Object)cookie);
            TicketGrantingTicket ticket = (TicketGrantingTicket)FunctionUtils.doAndHandle(() -> (TicketGrantingTicket)this.ticketRegistry.getTicket(c, TicketGrantingTicket.class), throwable -> null).get();
            if (ticket != null) {
                LOGGER.debug("Found ticket-granting ticket [{}]", (Object)ticket.getId());
                WebUtils.putTicketGrantingTicket((RequestContext)requestContext, (TicketGrantingTicket)ticket);
                WebUtils.putTicketGrantingTicketInScopes((RequestContext)requestContext, (TicketGrantingTicket)ticket);
            }
        });
        return null;
    }

    @Generated
    public FetchTicketGrantingTicketAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator) {
        this.ticketRegistry = ticketRegistry;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }
}

