/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchRequest;
import org.ldaptive.beans.spring.parser.AbstractBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.AbstractConnectionConfigBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.SearchOperationBeanDefinitionParser;
import org.ldaptive.pool.IdlePruneStrategy;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractConnectionFactoryBeanDefinitionParser
extends AbstractConnectionConfigBeanDefinitionParser {
    protected BeanDefinitionBuilder parseDefaultConnectionFactory(BeanDefinitionBuilder builder, Element element, boolean includeConnectionInitializer) {
        BeanDefinitionBuilder factory = builder;
        if (factory == null) {
            factory = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.class);
        }
        factory.addPropertyValue("connectionConfig", (Object)this.parseConnectionConfig(null, element, includeConnectionInitializer).getBeanDefinition());
        return factory;
    }

    protected BeanDefinitionBuilder parsePooledConnectionFactory(BeanDefinitionBuilder builder, String name, Element element, boolean includeConnectionInitializer) {
        BeanDefinitionBuilder pool = builder;
        if (pool == null) {
            pool = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
        }
        pool.addPropertyValue("name", (Object)name);
        pool.addPropertyValue("defaultConnectionFactory", (Object)this.parseDefaultConnectionFactory(null, element, includeConnectionInitializer).getBeanDefinition());
        pool.addPropertyValue("minPoolSize", (Object)element.getAttribute("minPoolSize"));
        pool.addPropertyValue("maxPoolSize", (Object)element.getAttribute("maxPoolSize"));
        pool.addPropertyValue("validateOnCheckOut", (Object)element.getAttribute("validateOnCheckOut"));
        pool.addPropertyValue("validatePeriodically", (Object)element.getAttribute("validatePeriodically"));
        BeanDefinitionBuilder blockWaitTime = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        blockWaitTime.addConstructorArgValue((Object)element.getAttribute("blockWaitTime"));
        pool.addPropertyValue("blockWaitTime", (Object)blockWaitTime.getBeanDefinition());
        pool.addPropertyValue("failFastInitialize", (Object)element.getAttribute("failFastInitialize"));
        BeanDefinitionBuilder pruneStrategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
        BeanDefinitionBuilder prunePeriod = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        prunePeriod.addConstructorArgValue((Object)element.getAttribute("prunePeriod"));
        BeanDefinitionBuilder idleTime = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        idleTime.addConstructorArgValue((Object)element.getAttribute("idleTime"));
        pruneStrategy.addPropertyValue("prunePeriod", (Object)prunePeriod.getBeanDefinition());
        pruneStrategy.addPropertyValue("idleTime", (Object)idleTime.getBeanDefinition());
        pool.addPropertyValue("pruneStrategy", (Object)pruneStrategy.getBeanDefinition());
        BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(SearchConnectionValidator.class);
        BeanDefinitionBuilder validatePeriod = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        validatePeriod.addConstructorArgValue((Object)element.getAttribute("validatePeriod"));
        BeanDefinitionBuilder validateTimeout = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        validateTimeout.addConstructorArgValue((Object)element.getAttribute("validateTimeout"));
        validator.addPropertyValue("validatePeriod", (Object)validatePeriod.getBeanDefinition());
        validator.addPropertyValue("validateTimeout", (Object)validateTimeout.getBeanDefinition());
        if (element.hasAttribute("validateDn") && element.hasAttribute("validateFilter")) {
            BeanDefinitionBuilder searchRequest = BeanDefinitionBuilder.genericBeanDefinition(SearchRequest.class);
            searchRequest.addPropertyValue("baseDn", (Object)element.getAttribute("validateDn"));
            BeanDefinitionBuilder filter = BeanDefinitionBuilder.rootBeanDefinition(SearchOperationBeanDefinitionParser.class, (String)"parseFilter");
            filter.addConstructorArgValue((Object)element.getAttribute("validateFilter"));
            searchRequest.addPropertyValue("filter", (Object)filter.getBeanDefinition());
            validator.addPropertyValue("searchRequest", (Object)searchRequest.getBeanDefinition());
        }
        pool.addPropertyValue("validator", (Object)validator.getBeanDefinition());
        if (element.hasAttribute("ldapUrl")) {
            pool.setInitMethodName("initialize");
        } else {
            this.logger.info("No ldapUrl attribute found for element {}, pool not initialized.", (Object)name);
        }
        return pool;
    }
}

