/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.VariableInstanceValueModifier;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class DefaultVariableInstanceValueModifier
implements VariableInstanceValueModifier {
    protected final VariableServiceConfiguration serviceConfiguration;

    public DefaultVariableInstanceValueModifier(VariableServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    @Override
    public void setVariableValue(VariableInstance variableInstance, Object value, String tenantId) {
        if (variableInstance instanceof VariableInstanceEntity) {
            VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
            VariableType variableType = this.determineVariableType(value);
            this.setVariableType(variableInstanceEntity, variableType);
        }
        variableInstance.setValue(value);
    }

    @Override
    public void updateVariableValue(VariableInstance variableInstance, Object value, String tenantId) {
        if (variableInstance instanceof VariableInstanceEntity) {
            VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
            VariableType variableType = this.determineVariableType(value);
            if (!variableType.equals(variableInstanceEntity.getType())) {
                this.updateVariableType(variableInstanceEntity, variableType);
            }
        }
        variableInstance.setValue(value);
    }

    protected void updateVariableType(VariableInstanceEntity variableInstance, VariableType variableType) {
        variableInstance.setValue(null);
        this.setVariableType(variableInstance, variableType);
        variableInstance.forceUpdate();
    }

    protected VariableType determineVariableType(Object value) {
        return this.serviceConfiguration.getVariableTypes().findVariableType(value);
    }

    protected void setVariableType(VariableInstanceEntity variableInstance, VariableType type) {
        variableInstance.setTypeName(type.getTypeName());
        variableInstance.setType(type);
    }
}

