/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import net.tirasa.adsddl.ntsd.controls.ShowDeletedControl;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.sync.ADSyncStrategy;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ad.util.DeletedControl;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.spi.SyncTokenResultsHandler;

public class USNSyncStrategy
extends ADSyncStrategy {
    private static final Log LOG = Log.getLog(USNSyncStrategy.class);
    private static String USN = "uSNChanged";
    private String deleteTokenValue;
    private String createOrUpdateTokenValue;

    public USNSyncStrategy(ADConnection conn) {
        super(conn);
    }

    protected List<SearchResult> search(LdapContext ctx, String filter, SearchControls searchCtls) throws Exception {
        ctx.setRequestControls(new Control[]{new SortControl(USN, true)});
        return super.search(ctx, filter, searchCtls, false);
    }

    protected List<SearchResult> searchForDeletedObjects(LdapContext ctx, String filter, SearchControls searchCtls) throws Exception {
        ctx.setRequestControls(new Control[]{new SortControl(USN, true), new ShowDeletedControl()});
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        Set<String> namingContexts = this.getNamingContexts(ctx);
        if (namingContexts.isEmpty()) {
            LOG.warn("No root context found about {0}", new Object[]{Arrays.asList(this.conn.getConfiguration().getBaseContextsToSynchronize())});
            return new ArrayList<SearchResult>();
        }
        String baseContextDn = namingContexts.iterator().next();
        if (LOG.isOk()) {
            LOG.ok("Searching from " + baseContextDn, new Object[0]);
        }
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(baseContextDn, filter, searchCtls);
            while (answer.hasMoreElements()) {
                result.add((SearchResult)answer.nextElement());
            }
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "While searching base context {0} with filter {1} and search controls {2}", new Object[]{baseContextDn, filter, searchCtls});
        }
        return result;
    }

    @Override
    public void sync(SyncToken token, SyncResultsHandler handler, OperationOptions options, ObjectClass oclass) {
        this.latestSyncToken = token;
        if (oclass.is(ObjectClass.ACCOUNT_NAME) && ((ADConfiguration)this.conn.getConfiguration()).isRetrieveDeletedUser() || oclass.is(ObjectClass.GROUP_NAME) && ((ADConfiguration)this.conn.getConfiguration()).isRetrieveDeletedGroup()) {
            this.syncDeletedObjects(token, handler, options, oclass);
        }
        this.syncCurrentObjects(token, handler, options, oclass);
    }

    private void sync(boolean deleted, String givenFilter, SyncToken token, SyncResultsHandler handler, OperationOptions options, ObjectClass oclass) {
        String filter;
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(null);
        try {
            if (token == null || token.getValue() == null || !(token.getValue() instanceof String) || token.getValue().toString().length() == 0) {
                if (LOG.isOk()) {
                    LOG.ok("Synchronization with empty token.", new Object[0]);
                }
                filter = givenFilter;
            } else {
                if (LOG.isOk()) {
                    LOG.ok("Synchronization with token {0}", new Object[]{token.getValue()});
                }
                String[] tokenValues = token.getValue().toString().split(",");
                this.deleteTokenValue = tokenValues[0];
                this.createOrUpdateTokenValue = tokenValues.length == 1 ? tokenValues[0] : tokenValues[1];
                filter = String.format("(&(!(%s<=%s))%s)", USN, deleted ? this.deleteTokenValue : this.createOrUpdateTokenValue, givenFilter);
            }
        }
        catch (Exception e) {
            throw new ConnectorException("Could not set Sync request controls", (Throwable)e);
        }
        if (LOG.isOk()) {
            LOG.ok("Search filter: " + filter, new Object[0]);
        }
        String[] attrsToGetOption = options.getAttributesToGet();
        Set<String> attrsToGet = this.utils.getAttributesToGet(attrsToGetOption, oclass);
        try {
            LdapContext ctx = this.conn.getInitialContext().newInstance(new Control[0]);
            List<SearchResult> changes = deleted ? this.searchForDeletedObjects(ctx, filter, searchCtls) : this.search(ctx, filter, searchCtls);
            int count = changes.size();
            LOG.ok("Found {0} changes", new Object[]{count});
            if (oclass.is(ObjectClass.ACCOUNT_NAME)) {
                for (SearchResult sr : changes) {
                    LOG.ok("Remaining {0} users to be processed", new Object[]{count});
                    try {
                        this.handleSyncUDelta(ctx, sr, attrsToGet, token, handler);
                        --count;
                    }
                    catch (NamingException e) {
                        LOG.error((Throwable)e, "SyncDelta handling for '{0}' failed", new Object[]{sr.getName()});
                    }
                }
            } else {
                for (SearchResult sr : changes) {
                    LOG.ok("Remaining {0} groups to be processed", new Object[]{count});
                    try {
                        this.handleSyncGDelta(ctx, sr, attrsToGet, token, handler);
                        --count;
                    }
                    catch (NamingException e) {
                        LOG.error((Throwable)e, "SyncDelta handling for '{0}' failed", new Object[]{sr.getName()});
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConnectorException("While looking for changes", (Throwable)e);
        }
        if (handler instanceof SyncTokenResultsHandler) {
            ((SyncTokenResultsHandler)SyncTokenResultsHandler.class.cast(handler)).handleResult(this.latestSyncToken);
        }
    }

    private void syncDeletedObjects(SyncToken token, SyncResultsHandler handler, OperationOptions options, ObjectClass oclass) {
        String filter = oclass.is(ObjectClass.ACCOUNT_NAME) ? "(&(objectClass=user)(isDeleted=TRUE))" : "(&(objectClass=group)(isDeleted=TRUE))";
        this.sync(true, filter, token, handler, options, oclass);
    }

    private void syncCurrentObjects(SyncToken token, SyncResultsHandler handler, OperationOptions options, ObjectClass oclass) {
        String filter = oclass.is(ObjectClass.ACCOUNT_NAME) ? USNSyncStrategy.createDirSyncUFilter((ADConfiguration)this.conn.getConfiguration(), this.utils) : USNSyncStrategy.createDirSyncGFilter();
        this.sync(false, filter, token, handler, options, oclass);
    }

    @Override
    public SyncToken getLatestSyncToken() {
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(0);
        searchCtls.setReturningAttributes(new String[]{"highestCommittedUSN"});
        String filter = "(objectclass=*)";
        try {
            String highestCommittedUSN = this.getHighestCommittedUSN(this.conn.getInitialContext().newInstance(null));
            if (highestCommittedUSN != null) {
                this.latestSyncToken = new SyncToken((Object)highestCommittedUSN);
            }
            if (LOG.isOk()) {
                LOG.ok("Latest sync token set to {0}", new Object[]{this.latestSyncToken});
            }
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "While searching for highestCommittedUSN with filter {1} and controls {2}", new Object[]{"(objectclass=*)", searchCtls});
        }
        return this.latestSyncToken;
    }

    private String getHighestCommittedUSN(LdapContext ctx) {
        try {
            DirContext dirContext = (DirContext)ctx.lookup("");
            Attributes attributes = dirContext.getAttributes("", new String[]{"highestCommittedUSN"});
            Attribute attribute = attributes.get("highestCommittedUSN");
            NamingEnumeration<?> all = attribute.getAll();
            if (all.hasMore()) {
                return (String)all.next();
            }
        }
        catch (NamingException e) {
            LOG.warn("While searching for highestCommittedUSN", new Object[]{e});
        }
        return null;
    }

    private Set<String> getNamingContexts(LdapContext ctx) {
        HashSet<String> namingContexts = new HashSet<String>();
        try {
            DirContext dirContext = (DirContext)ctx.lookup("");
            Attributes attributes = dirContext.getAttributes("", new String[]{"namingContexts"});
            Attribute attribute = attributes.get("namingContexts");
            NamingEnumeration<?> all = attribute.getAll();
            while (all.hasMore()) {
                String namingContext = (String)all.next();
                for (String baseContextDn : this.conn.getConfiguration().getBaseContextsToSynchronize()) {
                    if (!baseContextDn.toLowerCase().endsWith(namingContext.toLowerCase())) continue;
                    namingContexts.add(namingContext);
                }
            }
        }
        catch (NamingException e) {
            LOG.warn("While searching for naming contexts", new Object[]{e});
        }
        return namingContexts;
    }

    @Override
    protected SyncDelta getSyncDelta(ObjectClass oclass, String entryDN, SyncDeltaType syncDeltaType, SyncToken token, Attributes profile, Collection<String> attrsToGet, boolean effectiveDelete) throws NamingException {
        Attribute usn = profile.get(USN);
        if (usn != null) {
            if (effectiveDelete) {
                this.deleteTokenValue = usn.get().toString();
            } else {
                this.createOrUpdateTokenValue = usn.get().toString();
            }
            StringBuilder tokenBuilder = new StringBuilder();
            if (StringUtil.isNotBlank((String)this.deleteTokenValue)) {
                tokenBuilder.append(this.deleteTokenValue);
            }
            if (StringUtil.isNotBlank((String)this.createOrUpdateTokenValue)) {
                if (tokenBuilder.length() > 0) {
                    tokenBuilder.append(",");
                }
                tokenBuilder.append(this.createOrUpdateTokenValue);
            }
            this.latestSyncToken = new SyncToken((Object)tokenBuilder.toString());
        }
        LOG.ok("Latest processing token {0}", new Object[]{this.latestSyncToken.getValue()});
        return super.getSyncDelta(oclass, entryDN, syncDeltaType, this.latestSyncToken, profile, attrsToGet, effectiveDelete);
    }

    @Override
    protected void handleSyncGDelta(LdapContext ctx, SearchResult sr, Collection<String> attrsToGet, SyncToken token, SyncResultsHandler handler) throws NamingException {
        if (ctx == null || sr == null) {
            throw new ConnectorException("Invalid context or search result.");
        }
        ctx.setRequestControls(new Control[]{new DeletedControl()});
        Attributes profile = sr.getAttributes();
        if (LOG.isOk()) {
            LOG.ok("Object profile: {0}", new Object[]{profile});
        }
        String guid = GUID.getGuidAsString((byte[])((byte[])profile.get("objectGUID").get()));
        boolean isDeleted = false;
        try {
            Attribute attributeIsDeleted = profile.get("isDeleted");
            isDeleted = attributeIsDeleted != null && attributeIsDeleted.get() != null && Boolean.parseBoolean(attributeIsDeleted.get().toString());
        }
        catch (NoSuchElementException e) {
            if (LOG.isOk()) {
                LOG.ok("Cannot find the isDeleted element for group.", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.error(t, "Error retrieving isDeleted attribute", new Object[0]);
        }
        profile = ctx.getAttributes("<GUID=" + guid + ">");
        Attribute objectClasses = profile.get("objectClass");
        if (objectClasses.contains("group")) {
            ADConfiguration conf = (ADConfiguration)this.conn.getConfiguration();
            if (LOG.isOk()) {
                LOG.ok("Created/Updated/Deleted group {0}", new Object[]{sr.getNameInNamespace()});
            }
            if (isDeleted) {
                if (LOG.isOk()) {
                    LOG.ok("Deleted group {0}", new Object[]{sr.getNameInNamespace()});
                }
                if (conf.isRetrieveDeletedGroup()) {
                    handler.handle(this.getSyncDelta(ObjectClass.GROUP, sr.getNameInNamespace(), SyncDeltaType.DELETE, token, profile, attrsToGet, true));
                }
            } else {
                if (LOG.isOk()) {
                    LOG.ok("Created/Updated group {0}", new Object[]{sr.getNameInNamespace()});
                }
                String userDN = sr.getNameInNamespace();
                this.handleEntry(ctx, ObjectClass.GROUP, userDN, conf.getGroupSearchFilter(), handler, token, conf, attrsToGet);
            }
        } else {
            LOG.warn("Invalid object type {0}", new Object[]{objectClasses});
        }
    }

    private static String createDirSyncUFilter(ADConfiguration conf, ADUtilities utils) {
        StringBuilder filter = new StringBuilder();
        filter.append("(&(objectClass=user)").append(utils.getMembershipSearchFilter(conf)).append("(! (isDeleted=TRUE))").append(")");
        return filter.toString();
    }

    private static String createDirSyncGFilter() {
        return "(&(objectClass=group)(! (isDeleted=TRUE)))";
    }
}

