/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.authentication.SamlIdPAuthenticationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SamlIdPUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPUtils.class);

    public static Optional<Pair<? extends RequestAbstractType, MessageContext>> retrieveSamlRequest(WebContext context, SessionStore sessionStore, OpenSamlConfigBean openSamlConfigBean, Class<? extends RequestAbstractType> clazz) {
        LOGGER.trace("Retrieving authentication request from scope");
        Optional<Pair> authnContext = sessionStore.get(context, "SAMLRequest").map(String.class::cast).map(value -> SamlIdPUtils.retrieveSamlRequest(openSamlConfigBean, clazz, value)).flatMap(authnRequest -> sessionStore.get(context, MessageContext.class.getName()).map(String.class::cast).map(result -> SamlIdPAuthenticationContext.decode(result).toMessageContext(authnRequest)));
        return authnContext.map(ctx -> Pair.of((Object)((AuthnRequest)ctx.getMessage()), (Object)ctx));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends RequestAbstractType> T retrieveSamlRequest(OpenSamlConfigBean openSamlConfigBean, Class<T> clazz, String requestValue) {
        try {
            LOGGER.trace("Retrieving SAML request from [{}]", (Object)requestValue);
            byte[] decodedBytes = Base64Support.decode((String)requestValue);
            try (InflaterInputStream is = new InflaterInputStream(new ByteArrayInputStream(decodedBytes), new Inflater(true));){
                RequestAbstractType requestAbstractType = (RequestAbstractType)clazz.cast(XMLObjectSupport.unmarshallFromInputStream((ParserPool)openSamlConfigBean.getParserPool(), (InputStream)is));
                return (T)requestAbstractType;
            }
        }
        catch (Exception e) {
            return (T)((RequestAbstractType)FunctionUtils.doUnchecked(() -> {
                byte[] encodedRequest = EncodingUtils.decodeBase64((byte[])requestValue.getBytes(StandardCharsets.UTF_8));
                try (ByteArrayInputStream is = new ByteArrayInputStream(encodedRequest);){
                    RequestAbstractType requestAbstractType = (RequestAbstractType)clazz.cast(XMLObjectSupport.unmarshallFromInputStream((ParserPool)openSamlConfigBean.getParserPool(), (InputStream)is));
                    return requestAbstractType;
                }
            }));
        }
    }

    public static void preparePeerEntitySamlEndpointContext(Pair<? extends RequestAbstractType, MessageContext> authnContext, MessageContext outboundContext, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) throws SamlException {
        String entityId = adaptor.getEntityId();
        if (!adaptor.containsAssertionConsumerServices()) {
            throw new SamlException("No assertion consumer service could be found for entity " + entityId);
        }
        SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)outboundContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerEntityContext.setEntityId(entityId);
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        Endpoint endpoint = SamlIdPUtils.determineEndpointForRequest(authnContext, adaptor, binding);
        LOGGER.debug("Configured peer entity endpoint to be [{}] with binding [{}]", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
        endpointContext.setEndpoint(endpoint);
    }

    public static Endpoint determineEndpointForRequest(Pair<? extends RequestAbstractType, MessageContext> authnContext, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) {
        boolean missingLocation;
        Endpoint endpoint = null;
        RequestAbstractType authnRequest = (RequestAbstractType)authnContext.getLeft();
        if (authnRequest instanceof LogoutRequest) {
            endpoint = adaptor.getSingleLogoutService(binding);
        } else {
            AssertionConsumerService acsEndpointFromReq = SamlIdPUtils.getAssertionConsumerServiceFromRequest(authnRequest, binding, adaptor);
            AssertionConsumerService acsEndpointFromMetadata = adaptor.getAssertionConsumerService(binding);
            endpoint = SamlIdPUtils.determineEndpointForRequest(authnRequest, adaptor, binding, acsEndpointFromReq, acsEndpointFromMetadata, (MessageContext)authnContext.getRight());
        }
        if (endpoint == null) {
            throw new SamlException("Endpoint for " + authnRequest.getSchemaType() + " is not available or does not define a binding for " + binding);
        }
        boolean bl = missingLocation = StringUtils.isBlank((CharSequence)endpoint.getResponseLocation()) && StringUtils.isBlank((CharSequence)endpoint.getLocation());
        if (StringUtils.isBlank((CharSequence)endpoint.getBinding()) || missingLocation) {
            throw new SamlException("Endpoint for " + authnRequest.getSchemaType() + " does not define a binding or location for binding " + binding);
        }
        return endpoint;
    }

    private static AssertionConsumerService determineEndpointForRequest(RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, AssertionConsumerService acsFromRequest, AssertionConsumerService acsFromMetadata, MessageContext authenticationContext) {
        LOGGER.trace("ACS from authentication request is [{}], ACS from metadata is [{}] with binding [{}]", new Object[]{acsFromRequest, acsFromMetadata, binding});
        if (acsFromRequest != null) {
            if (!authnRequest.isSigned() && !SAMLBindingSupport.isMessageSigned((MessageContext)authenticationContext)) {
                Optional<String> result;
                Integer acsIndex;
                List<String> locations = StringUtils.isNotBlank((CharSequence)binding) ? adaptor.getAssertionConsumerServiceLocations(binding) : adaptor.getAssertionConsumerServiceLocations();
                String acsUrl = (String)StringUtils.defaultIfBlank((CharSequence)acsFromRequest.getResponseLocation(), (CharSequence)acsFromRequest.getLocation());
                Integer n = acsIndex = authnRequest instanceof AuthnRequest ? ((AuthnRequest)AuthnRequest.class.cast(authnRequest)).getAssertionConsumerServiceIndex() : null;
                if (StringUtils.isNotBlank((CharSequence)acsUrl) && locations.contains(acsUrl)) {
                    return SamlIdPUtils.buildAssertionConsumerService(binding, acsUrl, acsIndex);
                }
                if (acsIndex != null && (result = adaptor.getAssertionConsumerServiceFor(binding, acsIndex)).isPresent()) {
                    return SamlIdPUtils.buildAssertionConsumerService(binding, result.get(), acsIndex);
                }
                String message = String.format("Assertion consumer service [%s] cannot be located in metadata [%s]", acsUrl, locations);
                throw new SamlException(message);
            }
            return acsFromRequest;
        }
        return acsFromMetadata;
    }

    private static AssertionConsumerService buildAssertionConsumerService(String binding, String acsUrl, Integer acsIndex) {
        AssertionConsumerService acs = new AssertionConsumerServiceBuilder().buildObject();
        acs.setBinding(binding);
        acs.setLocation(acsUrl);
        acs.setResponseLocation(acsUrl);
        acs.setIndex(acsIndex);
        acs.setIsDefault(Boolean.TRUE);
        return acs;
    }

    public static MetadataResolver getMetadataResolverForAllSamlServices(ServicesManager servicesManager, String entityID, SamlRegisteredServiceCachingMetadataResolver resolver) {
        Collection registeredServices = servicesManager.findServiceBy(SamlRegisteredService.class::isInstance);
        ChainingMetadataResolver chainingMetadataResolver = new ChainingMetadataResolver();
        List resolvers = registeredServices.stream().filter(SamlRegisteredService.class::isInstance).map(SamlRegisteredService.class::cast).map(s -> SamlRegisteredServiceServiceProviderMetadataFacade.get(resolver, s, entityID)).filter(Optional::isPresent).map(Optional::get).map(SamlRegisteredServiceServiceProviderMetadataFacade::getMetadataResolver).collect(Collectors.toList());
        LOGGER.debug("Located [{}] metadata resolvers to match against [{}]", resolvers, (Object)entityID);
        FunctionUtils.doUnchecked(u -> {
            chainingMetadataResolver.setResolvers(resolvers);
            chainingMetadataResolver.setId(entityID);
            chainingMetadataResolver.initialize();
        }, (Object[])new Object[0]);
        return chainingMetadataResolver;
    }

    public static String getIssuerFromSamlObject(SAMLObject object) {
        if (object instanceof RequestAbstractType) {
            return ((RequestAbstractType)RequestAbstractType.class.cast(object)).getIssuer().getValue();
        }
        if (object instanceof StatusResponseType) {
            return ((StatusResponseType)StatusResponseType.class.cast(object)).getIssuer().getValue();
        }
        if (object instanceof Assertion) {
            return ((Assertion)Assertion.class.cast(object)).getIssuer().getValue();
        }
        return null;
    }

    public static RoleDescriptorResolver getRoleDescriptorResolver(SamlRegisteredServiceServiceProviderMetadataFacade adaptor, boolean requireValidMetadata) throws Exception {
        return SamlIdPUtils.getRoleDescriptorResolver(adaptor.getMetadataResolver(), requireValidMetadata);
    }

    public static RoleDescriptorResolver getRoleDescriptorResolver(MetadataResolver metadata, boolean requireValidMetadata) throws Exception {
        PredicateRoleDescriptorResolver roleDescriptorResolver = new PredicateRoleDescriptorResolver(metadata);
        roleDescriptorResolver.setSatisfyAnyPredicates(true);
        roleDescriptorResolver.setUseDefaultPredicateRegistry(true);
        roleDescriptorResolver.setRequireValidMetadata(requireValidMetadata);
        roleDescriptorResolver.initialize();
        return roleDescriptorResolver;
    }

    public static Optional<NameIDPolicy> getNameIDPolicy(RequestAbstractType authnRequest) {
        if (authnRequest instanceof AuthnRequest) {
            return Optional.ofNullable(((AuthnRequest)AuthnRequest.class.cast(authnRequest)).getNameIDPolicy());
        }
        return Optional.empty();
    }

    private static AssertionConsumerService getAssertionConsumerServiceFromRequest(RequestAbstractType request, String binding, SamlRegisteredServiceServiceProviderMetadataFacade adapter) {
        if (request instanceof AuthnRequest) {
            AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(request);
            String acsUrl = authnRequest.getAssertionConsumerServiceURL();
            Integer acsIndex = authnRequest.getAssertionConsumerServiceIndex();
            if (StringUtils.isBlank((CharSequence)acsUrl) && acsIndex == null) {
                LOGGER.debug("No assertion consumer service url or index is supplied in the authentication request");
                return null;
            }
            if (StringUtils.isBlank((CharSequence)acsUrl) && acsIndex != null) {
                LOGGER.debug("Locating assertion consumer service url for binding [{}] and index [{}]", (Object)acsUrl, (Object)acsIndex);
                acsUrl = adapter.getAssertionConsumerServiceFor(binding, acsIndex).orElseGet(() -> {
                    LOGGER.warn("Unable to locate acs url in for entity [{}] and binding [{}] with index [{}]", new Object[]{adapter.getEntityId(), binding, acsIndex});
                    return null;
                });
            }
            if (StringUtils.isNotBlank((CharSequence)acsUrl)) {
                LOGGER.debug("Fetched assertion consumer service url [{}] with binding [{}] from authentication request", (Object)acsUrl, (Object)binding);
                AssertionConsumerServiceBuilder builder = new AssertionConsumerServiceBuilder();
                AssertionConsumerService endpoint = (AssertionConsumerService)builder.buildObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
                endpoint.setBinding(binding);
                endpoint.setResponseLocation(acsUrl);
                endpoint.setLocation(acsUrl);
                endpoint.setIndex(acsIndex);
                return endpoint;
            }
        }
        return null;
    }

    public static void storeSamlRequest(JEEContext webContext, OpenSamlConfigBean openSamlConfigBean, SessionStore sessionStore, Pair<? extends SignableSAMLObject, MessageContext> context) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)context.getLeft();
        MessageContext messageContext = (MessageContext)context.getValue();
        try (StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)openSamlConfigBean, (XMLObject)authnRequest);){
            String samlRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
            sessionStore.set((WebContext)webContext, "SAMLRequest", (Object)samlRequest);
            sessionStore.set((WebContext)webContext, "RelayState", (Object)SAMLBindingSupport.getRelayState((MessageContext)messageContext));
            String authnContext = SamlIdPAuthenticationContext.from(messageContext).encode();
            sessionStore.set((WebContext)webContext, MessageContext.class.getName(), (Object)authnContext);
        }
    }

    public static String determineNameIdNameQualifier(SamlRegisteredService samlRegisteredService, MetadataResolver samlIdPMetadataResolver) {
        if (StringUtils.isNotBlank((CharSequence)samlRegisteredService.getNameIdQualifier())) {
            return samlRegisteredService.getNameIdQualifier();
        }
        String nameQualifier = (String)FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)samlRegisteredService.getIssuerEntityId()), samlRegisteredService::getIssuerEntityId, (Supplier)Unchecked.supplier(() -> {
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EvaluableEntityRoleEntityDescriptorCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME), new SamlIdPSamlRegisteredServiceCriterion(samlRegisteredService)});
            LOGGER.trace("Resolving entity id from SAML2 IdP metadata to determine issuer for [{}]", (Object)samlRegisteredService.getName());
            EntityDescriptor entityDescriptor = Objects.requireNonNull((EntityDescriptor)samlIdPMetadataResolver.resolveSingle((Object)criteriaSet));
            return entityDescriptor.getEntityID();
        })).get();
        LOGGER.debug("Using name qualifier [{}] for the Name ID", (Object)nameQualifier);
        return nameQualifier;
    }

    @Generated
    private SamlIdPUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

