/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.text.ParseException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ReportCheck;
import org.quartz.CronExpression;

public class ReportValidator
extends AbstractValidator<ReportCheck, Report> {
    public boolean isValid(Report report, ConstraintValidatorContext context) {
        Set reportletKeys;
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (this.isHtml(report.getName())) {
            context.buildConstraintViolationWithTemplate(ReportValidator.getTemplate(EntityViolationType.InvalidName, report.getName())).addPropertyNode("name").addConstraintViolation();
            isValid = false;
        }
        if (report.getCronExpression() != null) {
            try {
                new CronExpression(report.getCronExpression());
            }
            catch (ParseException e) {
                LOG.error("Invalid cron expression '" + report.getCronExpression() + "'", (Throwable)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(ReportValidator.getTemplate(EntityViolationType.InvalidReport, "Invalid cron expression")).addPropertyNode("cronExpression").addConstraintViolation();
            }
        }
        if ((reportletKeys = report.getReportlets().stream().map(Entity::getKey).collect(Collectors.toSet())).size() != report.getReportlets().size()) {
            LOG.error("Reportlet key must be unique");
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(ReportValidator.getTemplate(EntityViolationType.InvalidReport, "Reportlet name must be unique")).addPropertyNode("reportletConfs").addConstraintViolation();
        }
        return isValid;
    }
}

