/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.policy;

import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtils;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;

public class JPAPolicyUtils
implements PolicyUtils {
    private final PolicyType type;

    protected JPAPolicyUtils(PolicyType type) {
        this.type = type;
    }

    public PolicyType getType() {
        return this.type;
    }

    public Class<? extends Policy> policyClass() {
        switch (this.type) {
            case ACCOUNT: {
                return AccountPolicy.class;
            }
            case PASSWORD: {
                return PasswordPolicy.class;
            }
            case AUTH: {
                return AuthPolicy.class;
            }
            case ATTR_RELEASE: {
                return AttrReleasePolicy.class;
            }
            case ACCESS: {
                return AccessPolicy.class;
            }
            case PROPAGATION: {
                return PropagationPolicy.class;
            }
            case PULL: {
                return PullPolicy.class;
            }
        }
        return PushPolicy.class;
    }
}

