/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.policy.DefaultPullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PullCorrelationRuleConf;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRuleConfClass;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.SyncDelta;

@PullCorrelationRuleConfClass(value=DefaultPullCorrelationRuleConf.class)
public class DefaultPullCorrelationRule
implements PullCorrelationRule {
    private DefaultPullCorrelationRuleConf conf;

    public void setConf(PullCorrelationRuleConf conf) {
        if (!(conf instanceof DefaultPullCorrelationRuleConf)) {
            throw new IllegalArgumentException(DefaultPullCorrelationRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultPullCorrelationRuleConf)DefaultPullCorrelationRuleConf.class.cast(conf);
    }

    public SearchCond getSearchCond(SyncDelta syncDelta, Provision provision) {
        Map mappingItems = provision.getMapping().getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Function.identity()));
        ArrayList searchConds = new ArrayList();
        this.conf.getSchemas().forEach(schema -> {
            AttrCond.Type type;
            Attribute attr = Optional.ofNullable((Item)mappingItems.get(schema)).map(item -> syncDelta.getObject().getAttributeByName(item.getExtAttrName())).orElse(null);
            if (attr == null) {
                throw new IllegalArgumentException("Connector object does not contains the attributes to perform the search: " + schema);
            }
            String expression = null;
            if (attr.getValue() == null || attr.getValue().isEmpty() || attr.getValue().size() == 1 && attr.getValue().get(0) == null) {
                type = AttrCond.Type.ISNULL;
            } else {
                type = AttrCond.Type.EQ;
                expression = attr.getValue().size() > 1 ? attr.getValue().toString() : attr.getValue().get(0).toString();
            }
            AnyCond cond = "key".equalsIgnoreCase((String)schema) || "username".equalsIgnoreCase((String)schema) || "name".equalsIgnoreCase((String)schema) ? new AnyCond() : new AttrCond();
            cond.setSchema(schema);
            cond.setType(type);
            cond.setExpression(expression);
            searchConds.add(SearchCond.getLeaf((AbstractSearchCond)cond));
        });
        return this.conf.isOrSchemas() ? SearchCond.getOr(searchConds) : SearchCond.getAnd(searchConds);
    }
}

