/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.Alias;
import com.google.api.services.admin.directory.model.User;
import com.google.api.services.admin.directory.model.UserName;
import com.google.api.services.admin.directory.model.UserPhoto;
import com.google.common.base.CharMatcher;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCustomSchema;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributeInfos;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class UserHandler
implements FilterVisitor<StringBuilder, Directory.Users.List> {
    private static final Log LOG = Log.getLog(UserHandler.class);
    private static final Map<String, String> NAME_DICTIONARY;
    private static final Set<String> S;
    private static final Set<String> SW;
    private static final Escaper STRING_ESCAPER;

    public StringBuilder visitAndFilter(Directory.Users.List list, AndFilter andFilter) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Filter filter : andFilter.getFilters()) {
            StringBuilder sb = (StringBuilder)filter.accept((FilterVisitor)this, (Object)list);
            if (null == sb) continue;
            if (!first) {
                builder.append(' ');
            } else {
                first = false;
            }
            builder.append((CharSequence)sb);
        }
        return builder;
    }

    public StringBuilder visitContainsFilter(Directory.Users.List list, ContainsFilter filter) {
        String filedName = NAME_DICTIONARY.get(filter.getName());
        if (null != filedName && S.contains(filedName)) {
            return this.getStringBuilder(filter.getAttribute(), ':', null, filedName);
        }
        throw new InvalidAttributeValueException("");
    }

    protected StringBuilder getStringBuilder(Attribute attribute, char operator, Character postfix, String filedName) {
        StringBuilder builder = new StringBuilder();
        builder.append(filedName).append(operator);
        String stringValue = AttributeUtil.getAsStringValue((Attribute)attribute);
        if (StringUtil.isNotBlank((String)stringValue)) {
            stringValue = STRING_ESCAPER.escape(stringValue);
            if (CharMatcher.whitespace().matchesAnyOf((CharSequence)stringValue)) {
                builder.append('\'').append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
                builder.append('\'');
            } else {
                builder.append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
            }
        }
        return builder;
    }

    public StringBuilder visitStartsWithFilter(Directory.Users.List list, StartsWithFilter filter) {
        String filedName = NAME_DICTIONARY.get(filter.getName());
        if (null != filedName && SW.contains(filedName)) {
            return this.getStringBuilder(filter.getAttribute(), ':', Character.valueOf('*'), filedName);
        }
        throw new InvalidAttributeValueException("");
    }

    public StringBuilder visitEqualsFilter(Directory.Users.List list, EqualsFilter equalsFilter) {
        if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"customer")) {
            if (null != list.getDomain()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"domain")) {
            if (null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = NAME_DICTIONARY.get(equalsFilter.getName());
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitEqualsIgnoreCaseFilter(Directory.Users.List list, EqualsIgnoreCaseFilter equalsFilter) {
        if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"customer")) {
            if (null != list.getDomain()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"domain")) {
            if (null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = NAME_DICTIONARY.get(equalsFilter.getName());
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitContainsAllValuesFilter(Directory.Users.List list, ContainsAllValuesFilter filter) {
        return null;
    }

    public StringBuilder visitExtendedFilter(Directory.Users.List list, Filter filter) {
        return null;
    }

    public StringBuilder visitGreaterThanFilter(Directory.Users.List list, GreaterThanFilter filter) {
        return null;
    }

    public StringBuilder visitGreaterThanOrEqualFilter(Directory.Users.List list, GreaterThanOrEqualFilter filter) {
        return null;
    }

    public StringBuilder visitLessThanFilter(Directory.Users.List list, LessThanFilter filter) {
        return null;
    }

    public StringBuilder visitLessThanOrEqualFilter(Directory.Users.List list, LessThanOrEqualFilter filter) {
        return null;
    }

    public StringBuilder visitNotFilter(Directory.Users.List list, NotFilter filter) {
        return null;
    }

    public StringBuilder visitOrFilter(Directory.Users.List list, OrFilter filter) {
        return null;
    }

    public StringBuilder visitEndsWithFilter(Directory.Users.List list, EndsWithFilter filter) {
        return null;
    }

    public static ObjectClassInfo getUserClassInfo(String customSchemasJSON) {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"givenName").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"familyName").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"fullName").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"isAdmin", Boolean.TYPE));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"isDelegatedAdmin", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"lastLoginTime").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"creationTime").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"agreedToTerms", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)OperationalAttributes.PASSWORD_NAME, GuardedString.class).setRequired(true).setReadable(false).setReturnedByDefault(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"suspensionReason").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"changePasswordAtNextLogin", Boolean.class));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"ipWhitelisted", Boolean.class));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"externalIds", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"relations", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"organizations", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"phones", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"aliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"nonEditableAliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"customerId").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"orgUnitPath"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"isMailboxSetup", Boolean.class).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"includeInGlobalAddressList", Boolean.class));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"thumbnailPhotoUrl").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"deletionTime").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"__PHOTO__", byte[].class).setReturnedByDefault(false).build());
        builder.addAttributeInfo(PredefinedAttributeInfos.GROUPS);
        if (StringUtil.isNotBlank((String)customSchemasJSON)) {
            List<GoogleAppsCustomSchema> customSchemas = GoogleAppsUtil.extractCustomSchemas(customSchemasJSON);
            for (GoogleAppsCustomSchema customSchema : customSchemas) {
                if (customSchema.getType().equals("object")) {
                    String basicName = customSchema.getName();
                    for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                        builder.addAttributeInfo(UserHandler.getAttributeInfoBuilder(basicName + "." + innerSchema.getName(), innerSchema).build());
                    }
                    continue;
                }
                LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
            }
        }
        return builder.build();
    }

    private static AttributeInfoBuilder getAttributeInfoBuilder(String name, GoogleAppsCustomSchema schema) {
        AttributeInfoBuilder attributeInfoBuilder = AttributeInfoBuilder.define((String)name);
        attributeInfoBuilder.setMultiValued(schema.getMultiValued().booleanValue());
        switch (schema.getType()) {
            case "string": {
                attributeInfoBuilder.setType(String.class);
                break;
            }
            case "boolean": {
                attributeInfoBuilder.setType(Boolean.class);
                break;
            }
            case "int": {
                attributeInfoBuilder.setType(Integer.class);
            }
        }
        return attributeInfoBuilder;
    }

    public static Directory.Users.Insert createUser(Directory.Users users, AttributesAccessor attributes, String customSchemas) {
        User user = new User();
        user.setPrimaryEmail(GoogleAppsUtil.getName(attributes.getName()));
        GuardedString password = attributes.getPassword();
        if (null == password) {
            throw new InvalidAttributeValueException("Missing required attribute '__PASSWORD__'");
        }
        user.setPassword(SecurityUtil.decrypt((GuardedString)password));
        user.setName(new UserName());
        String givenName = attributes.findString("givenName");
        if (!StringUtil.isNotBlank((String)givenName)) {
            throw new InvalidAttributeValueException("Missing required attribute 'givenName'.The user's first name. Required when creating a user account.");
        }
        user.getName().setGivenName(givenName);
        String familyName = attributes.findString("familyName");
        if (!StringUtil.isNotBlank((String)familyName)) {
            throw new InvalidAttributeValueException("Missing required attribute 'familyName'.The user's last name. Required when creating a user account.");
        }
        user.getName().setFamilyName(familyName);
        user.setIms((Object)attributes.findList("ims"));
        user.setEmails((Object)attributes.findList("emails"));
        user.setExternalIds((Object)attributes.findList("externalIds"));
        user.setRelations((Object)attributes.findList("relations"));
        user.setAddresses((Object)attributes.findList("addresses"));
        user.setOrganizations((Object)attributes.findList("organizations"));
        user.setPhones((Object)attributes.findList("phones"));
        Boolean enable = attributes.findBoolean(OperationalAttributes.ENABLE_NAME);
        if (null != enable) {
            user.setSuspended(Boolean.valueOf(enable == false));
        }
        user.setChangePasswordAtNextLogin(attributes.findBoolean("changePasswordAtNextLogin"));
        user.setIpWhitelisted(attributes.findBoolean("ipWhitelisted"));
        user.setOrgUnitPath(attributes.findString("orgUnitPath"));
        user.setIncludeInGlobalAddressList(attributes.findBoolean("includeInGlobalAddressList"));
        if (StringUtil.isNotBlank((String)customSchemas)) {
            UserHandler.addOrReplaceCustomSchemas(customSchemas, attributes, user);
        }
        try {
            return users.insert(user).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static void addOrReplaceCustomSchemas(String customSchemasJSON, AttributesAccessor attributes, User user) {
        List<GoogleAppsCustomSchema> schemas = GoogleAppsUtil.extractCustomSchemas(customSchemasJSON);
        HashMap attrsToAdd = new HashMap();
        for (GoogleAppsCustomSchema customSchema : schemas) {
            if (customSchema.getType().equals("object")) {
                String basicName = customSchema.getName();
                for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                    String innerSchemaName = basicName + "." + innerSchema.getName();
                    if (attrsToAdd.containsKey(basicName)) {
                        ((Map)attrsToAdd.get(basicName)).put(innerSchema.getName(), UserHandler.getValueByType(innerSchema, attributes, innerSchemaName));
                        continue;
                    }
                    HashMap<String, Object> value = new HashMap<String, Object>();
                    value.put(innerSchema.getName(), UserHandler.getValueByType(innerSchema, attributes, innerSchemaName));
                    attrsToAdd.put(basicName, value);
                }
            } else {
                LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
            }
            user.setCustomSchemas(attrsToAdd);
        }
    }

    private static Object getValueByType(GoogleAppsCustomSchema innerSchema, AttributesAccessor attributes, String innerSchemaName) {
        return innerSchema.getMultiValued() != false ? attributes.findStringList(innerSchemaName) : attributes.findString(innerSchemaName);
    }

    public static Directory.Users.Patch updateUser(Directory.Users users, String userKey, AttributesAccessor attributes, String customSchemasJSON) {
        Boolean booleanValue;
        Attribute includeInGlobalAddressList;
        String stringValue;
        Attribute orgUnitPath;
        Attribute phones;
        Attribute organizations;
        Attribute addresses;
        Attribute relations;
        Attribute externalIds;
        Attribute emails;
        Attribute ims;
        Boolean booleanValue2;
        Attribute ipWhitelisted;
        Boolean booleanValue3;
        Attribute changePasswordAtNextLogin;
        Boolean enable;
        GuardedString password;
        String stringValue2;
        Attribute familyName;
        String stringValue3;
        Attribute givenName;
        User content = null;
        Name email = attributes.getName();
        if (email != null && email.getNameValue() != null) {
            content = new User();
            content.setPrimaryEmail(email.getNameValue());
        }
        if (null != (givenName = attributes.find("givenName")) && null != (stringValue3 = GoogleAppsUtil.getStringValueWithDefault(givenName, null))) {
            if (null == content) {
                content = new User();
            }
            content.setName(new UserName());
            content.getName().setGivenName(stringValue3);
        }
        if (null != (familyName = attributes.find("familyName")) && null != (stringValue2 = GoogleAppsUtil.getStringValueWithDefault(familyName, null))) {
            if (null == content) {
                content = new User();
            }
            if (null == content.getName()) {
                content.setName(new UserName());
            }
            content.getName().setFamilyName(stringValue2);
        }
        if (null != (password = attributes.getPassword())) {
            if (null == content) {
                content = new User();
            }
            content.setPassword(SecurityUtil.decrypt((GuardedString)password));
        }
        if (null != (enable = attributes.findBoolean(OperationalAttributes.ENABLE_NAME))) {
            if (null == content) {
                content = new User();
            }
            content.setSuspended(Boolean.valueOf(enable == false));
        }
        if (null != (changePasswordAtNextLogin = attributes.find("changePasswordAtNextLogin")) && null != (booleanValue3 = GoogleAppsUtil.getBooleanValueWithDefault(changePasswordAtNextLogin, null))) {
            if (null == content) {
                content = new User();
            }
            content.setChangePasswordAtNextLogin(booleanValue3);
        }
        if (null != (ipWhitelisted = attributes.find("ipWhitelisted")) && null != (booleanValue2 = GoogleAppsUtil.getBooleanValueWithDefault(ipWhitelisted, null))) {
            if (null == content) {
                content = new User();
            }
            content.setIpWhitelisted(booleanValue2);
        }
        if (null != (ims = attributes.find("ims"))) {
            if (null == content) {
                content = new User();
            }
            content.setIms((Object)ims.getValue());
        }
        if (null != (emails = attributes.find("emails"))) {
            if (null == content) {
                content = new User();
            }
            content.setEmails((Object)emails.getValue());
        }
        if (null != (externalIds = attributes.find("externalIds"))) {
            if (null == content) {
                content = new User();
            }
            content.setExternalIds((Object)externalIds.getValue());
        }
        if (null != (relations = attributes.find("relations"))) {
            if (null == content) {
                content = new User();
            }
            content.setRelations((Object)relations.getValue());
        }
        if (null != (addresses = attributes.find("addresses"))) {
            if (null == content) {
                content = new User();
            }
            content.setAddresses((Object)addresses.getValue());
        }
        if (null != (organizations = attributes.find("organizations"))) {
            if (null == content) {
                content = new User();
            }
            content.setOrganizations((Object)organizations.getValue());
        }
        if (null != (phones = attributes.find("phones"))) {
            if (null == content) {
                content = new User();
            }
            content.setPhones((Object)phones.getValue());
        }
        if (null != (orgUnitPath = attributes.find("orgUnitPath")) && null != (stringValue = GoogleAppsUtil.getStringValueWithDefault(orgUnitPath, null))) {
            if (null == content) {
                content = new User();
            }
            content.setOrgUnitPath(stringValue);
        }
        if (null != (includeInGlobalAddressList = attributes.find("includeInGlobalAddressList")) && null != (booleanValue = GoogleAppsUtil.getBooleanValueWithDefault(includeInGlobalAddressList, null))) {
            if (null == content) {
                content = new User();
            }
            content.setIncludeInGlobalAddressList(booleanValue);
        }
        if (StringUtil.isNotBlank((String)customSchemasJSON)) {
            UserHandler.addOrReplaceCustomSchemas(customSchemasJSON, attributes, content);
        }
        if (null == content) {
            return null;
        }
        try {
            return users.patch(userKey, content).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Users#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Users.Photos.Update createUpdateUserPhoto(Directory.Users.Photos service, String userKey, byte[] data) {
        UserPhoto content = new UserPhoto();
        content.setPhotoData(Base64.getMimeEncoder().encodeToString(data));
        try {
            return service.update(userKey, content).setFields("id");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Users.Aliases.Insert createUserAlias(Directory.Users.Aliases service, String userKey, String alias) {
        Alias content = new Alias();
        content.setAlias(alias);
        try {
            return service.insert(userKey, content).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Users.Aliases.Delete deleteUserAlias(Directory.Users.Aliases service, String userKey, String alias) {
        try {
            return service.delete(userKey, alias);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    static {
        SortedMap dictionary = CollectionUtil.newCaseInsensitiveMap();
        dictionary.put(Uid.NAME, Uid.NAME);
        dictionary.put("email", "email");
        dictionary.put(Name.NAME, "email");
        dictionary.put("givenName", "givenName");
        dictionary.put("familyName", "familyName");
        dictionary.put("isAdmin", "isAdmin");
        dictionary.put("isDelegatedAdmin", "isDelegatedAdmin");
        dictionary.put("isSuspended", "isSuspended");
        dictionary.put("im", "im");
        dictionary.put("externalId", "externalId");
        dictionary.put("manager", "manager");
        dictionary.put("managerId", "managerId");
        dictionary.put("directManager", "directManager");
        dictionary.put("directManagerId", "directManagerId");
        dictionary.put("address", "address");
        dictionary.put("addressPoBox", "addressPoBox");
        dictionary.put("address/poBox", "addressPoBox");
        dictionary.put("addressExtended", "addressExtended");
        dictionary.put("address/extended", "addressExtended");
        dictionary.put("addressStreet", "addressStreet");
        dictionary.put("address/street", "addressStreet");
        dictionary.put("addressLocality", "addressLocality");
        dictionary.put("address/locality", "addressLocality");
        dictionary.put("addressRegion", "addressRegion");
        dictionary.put("address/region", "addressRegion");
        dictionary.put("addressPostalCode", "addressPostalCode");
        dictionary.put("address/postalCode", "addressPostalCode");
        dictionary.put("addressCountry", "addressCountry");
        dictionary.put("address/country", "addressCountry");
        dictionary.put("orgName", "orgName");
        dictionary.put("organizations/name", "orgName");
        NAME_DICTIONARY = dictionary;
        SortedSet s = CollectionUtil.newCaseInsensitiveSet();
        s.add(Name.NAME);
        s.add("email");
        s.add("givenName");
        s.add("familyName");
        SW = CollectionUtil.newCaseInsensitiveSet();
        SW.addAll(s);
        s.add("im");
        s.add("externalId");
        s.add("address");
        s.add("addressPoBox");
        s.add("addressExtended");
        s.add("addressStreet");
        s.add("addressLocality");
        s.add("addressRegion");
        s.add("addressPostalCode");
        s.add("addressCountry");
        s.add("orgName");
        s.add("orgTitle");
        s.add("orgDepartment");
        s.add("orgDescription");
        s.add("orgCostCenter");
        S = s;
        STRING_ESCAPER = Escapers.builder().addEscape('\'', "\\'").build();
    }
}

