/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.job;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Validator;
import org.apache.syncope.common.lib.command.CommandArgs;
import org.apache.syncope.core.logic.api.Command;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class MacroRunJobDelegate
extends AbstractSchedTaskJobDelegate<MacroTask> {
    @Autowired
    protected ImplementationDAO implementationDAO;
    @Autowired
    protected Validator validator;
    protected final Map<String, Command<?>> perContextCommands = new ConcurrentHashMap();

    protected String doExecute(boolean dryRun, String executor, JobExecutionContext context) throws JobExecutionException {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < ((MacroTask)this.task).getCommands().size(); ++i) {
            Command runnable;
            Implementation command = (Implementation)((MacroTask)this.task).getCommands().get(i);
            try {
                runnable = (Command)ImplementationManager.build((Implementation)command, () -> this.perContextCommands.get(command.getKey()), instance -> this.perContextCommands.put(command.getKey(), (Command<?>)instance));
            }
            catch (Exception e) {
                throw new JobExecutionException("Could not build " + command.getKey(), (Throwable)e);
            }
            String args = POJOHelper.serialize(((MacroTask)this.task).getCommandArgs().get(i));
            output.append("Command[").append(i).append("]: ").append(command.getKey()).append(" ").append(args).append("\n");
            if (dryRun) {
                output.append(command).append(' ').append(args);
            } else {
                try {
                    Set violations;
                    if (((MacroTask)this.task).getCommandArgs().get(i) != null && !(violations = this.validator.validate(((MacroTask)this.task).getCommandArgs().get(i), new Class[0])).isEmpty()) {
                        LOG.error("Errors while validating {}: {}", ((MacroTask)this.task).getCommandArgs().get(i), (Object)violations);
                        throw new IllegalArgumentException(((CommandArgs)((MacroTask)this.task).getCommandArgs().get(i)).getClass().getName());
                    }
                    output.append(runnable.run((CommandArgs)((MacroTask)this.task).getCommandArgs().get(i)));
                }
                catch (Exception e) {
                    if (((MacroTask)this.task).isContinueOnError()) {
                        output.append("Continuing on error: <").append(e.getMessage()).append('>');
                        LOG.error("While running {} with args {}, continuing on error", new Object[]{command.getKey(), args, e});
                    }
                    throw new RuntimeException("While running " + command.getKey(), e);
                }
            }
            output.append("\n\n");
        }
        output.append("COMPLETED");
        return output.toString();
    }

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return ((MacroTask)this.task).isSaveExecs();
    }
}

