/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.access.prepost.PreAuthorize;

public class AccessTokenLogic
extends AbstractTransactionalLogic<AccessTokenTO> {
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected final SecurityProperties securityProperties;
    protected final AccessTokenDataBinder binder;
    protected final AccessTokenDAO accessTokenDAO;

    protected static byte[] getAuthorities() {
        byte[] authorities = null;
        try {
            authorities = ENCRYPTOR.encode(POJOHelper.serialize((Object)AuthContextUtils.getAuthorities()), CipherAlgorithm.AES).getBytes();
        }
        catch (Exception e) {
            LOG.error("Could not fetch authorities", (Throwable)e);
        }
        return authorities;
    }

    public AccessTokenLogic(SecurityProperties securityProperties, AccessTokenDataBinder binder, AccessTokenDAO accessTokenDAO) {
        this.securityProperties = securityProperties;
        this.binder = binder;
        this.accessTokenDAO = accessTokenDAO;
    }

    @PreAuthorize(value="isAuthenticated()")
    public Pair<String, OffsetDateTime> login() {
        if (this.securityProperties.getAnonymousUser().equals(AuthContextUtils.getUsername())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(this.securityProperties.getAnonymousUser() + " cannot be granted an access token");
            throw sce;
        }
        return this.binder.create(AuthContextUtils.getUsername(), Collections.emptyMap(), AccessTokenLogic.getAuthorities(), false);
    }

    @PreAuthorize(value="isAuthenticated()")
    public Pair<String, OffsetDateTime> refresh() {
        AccessToken accessToken = this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername());
        if (accessToken == null) {
            throw new NotFoundException("AccessToken for " + AuthContextUtils.getUsername());
        }
        return this.binder.update(accessToken, AccessTokenLogic.getAuthorities());
    }

    @PreAuthorize(value="isAuthenticated()")
    public void logout() {
        AccessToken accessToken = this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername());
        if (accessToken == null) {
            throw new NotFoundException("AccessToken for " + AuthContextUtils.getUsername());
        }
        this.delete(accessToken.getKey());
    }

    @PreAuthorize(value="hasRole('ACCESS_TOKEN_LIST')")
    public Pair<Integer, List<AccessTokenTO>> list(int page, int size, List<OrderByClause> orderByClauses) {
        Integer count = this.accessTokenDAO.count();
        List result = this.accessTokenDAO.findAll(page, size, orderByClauses).stream().map(arg_0 -> ((AccessTokenDataBinder)this.binder).getAccessTokenTO(arg_0)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @PreAuthorize(value="hasRole('ACCESS_TOKEN_DELETE')")
    public void delete(String key) {
        this.accessTokenDAO.delete(key);
    }

    @Override
    protected AccessTokenTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

