/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.ticket;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder
implements ExpirationPolicyBuilder<TransientSessionTicket> {
    private static final long serialVersionUID = -3597980180617072826L;
    protected final CasConfigurationProperties casProperties;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        CasSimpleMultifactorAuthenticationProperties simple = this.casProperties.getAuthn().getMfa().getSimple();
        return new HardTimeoutExpirationPolicy(simple.getToken().getCore().getTimeToKillInSeconds());
    }

    @Generated
    public CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder(casProperties=" + this.casProperties + ")";
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

