/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.syncope.common.rest.api.service.ReportService;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.ReportLogic;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.rest.cxf.service.AbstractExecutableService;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
extends AbstractExecutableService
implements ReportService {
    protected final ReportLogic logic;

    public ReportServiceImpl(ReportLogic logic) {
        this.logic = logic;
    }

    @Override
    protected AbstractExecutableLogic<?> getExecutableLogic() {
        return this.logic;
    }

    public Response create(ReportTO reportTO) {
        ReportTO createdReportTO = this.logic.create(reportTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(createdReportTO.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)createdReportTO.getKey()).build();
    }

    public void update(ReportTO reportTO) {
        this.logic.update(reportTO);
    }

    public List<ReportTO> list() {
        return this.logic.list();
    }

    public ReportTO read(String key) {
        return this.logic.read(key);
    }

    public Response exportExecutionResult(String executionKey, ReportExecExportFormat fmt) {
        ReportExecExportFormat format = Optional.ofNullable(fmt).orElse(ReportExecExportFormat.XML);
        ReportExec reportExec = this.logic.getReportExec(executionKey);
        StreamingOutput sout = os -> this.logic.exportExecutionResult(os, reportExec, format);
        return Response.ok((Object)sout).header("Content-Disposition", (Object)("attachment; filename=" + reportExec.getReport().getName() + "." + format.name().toLowerCase())).build();
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

