/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ConfParamDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConfParam;
import org.apache.syncope.core.persistence.api.entity.SelfKeymasterEntityFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ConfParamLogic
extends AbstractTransactionalLogic<EntityTO> {
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ConfParamDAO confParamDAO;
    protected final SelfKeymasterEntityFactory entityFactory;

    public ConfParamLogic(ConfParamDAO confParamDAO, SelfKeymasterEntityFactory entityFactory) {
        this.confParamDAO = confParamDAO;
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    @Transactional(readOnly=true)
    public Map<String, Object> list() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        this.confParamDAO.findAll().forEach(param -> {
            try {
                params.put(param.getKey(), MAPPER.treeToValue((TreeNode)param.getValue(), Object.class));
            }
            catch (JsonProcessingException e) {
                LOG.error("While processing {}'s value", (Object)param.getKey(), (Object)e);
            }
        });
        return params;
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    @Transactional(readOnly=true)
    public JsonNode get(String key) {
        ConfParam param = this.confParamDAO.find(key);
        return Optional.ofNullable(param).map(ConfParam::getValue).orElse(null);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public void set(String key, JsonNode value) {
        ConfParam param = this.confParamDAO.find(key);
        if (param == null) {
            param = this.entityFactory.newConfParam();
            param.setKey(key);
        }
        if (value == null) {
            throw new NotFoundException("No value provided for " + key);
        }
        param.setValue(value);
        this.confParamDAO.save(param);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public void remove(String key) {
        this.confParamDAO.delete(key);
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnsupportedOperationException();
    }
}

