/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.html;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.references.ModernizrJavaScriptReference;
import de.agilecoders.wicket.core.util.CssClassNames;
import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.request.resource.ResourceReference;

public class HtmlTag
extends TransparentWebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final boolean useModernizr;
    private final Locale locale;

    public HtmlTag(String markupId, Locale locale, boolean useModernizr) {
        super(markupId);
        this.locale = locale;
        this.useModernizr = useModernizr;
    }

    public HtmlTag(String markupId, boolean useModernizr) {
        this(markupId, Locale.ENGLISH, useModernizr);
    }

    public HtmlTag(String markupId, Locale locale) {
        this(markupId, locale, false);
    }

    public HtmlTag(String markupId) {
        this(markupId, Locale.ENGLISH, false);
    }

    private String toAttributeValue(Locale locale) {
        return locale.toLanguageTag();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "html");
        if (this.locale != null) {
            tag.put("lang", (CharSequence)this.toAttributeValue(this.locale));
        }
        CssClassNames.Builder cssClassNames = CssClassNames.newBuilder();
        if (this.useModernizr) {
            cssClassNames.add("no-js");
        }
        cssClassNames.add("theme-" + Bootstrap.getSettings().getActiveThemeProvider().getActiveTheme().name());
        tag.put("class", (CharSequence)cssClassNames.asString());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.useModernizr) {
            response.render(this.newModernizrHeaderItem());
        }
    }

    protected HeaderItem newModernizrHeaderItem() {
        return JavaScriptHeaderItem.forReference((ResourceReference)ModernizrJavaScriptReference.instance());
    }
}

