/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.impl.apache.client5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.http.common.api.HttpHeaders;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.MultiValuePart;
import org.flowable.http.common.api.client.AsyncExecutableHttpRequest;
import org.flowable.http.common.api.client.FlowableAsyncHttpClient;
import org.flowable.http.common.impl.HttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpComponents5FlowableHttpClient
implements FlowableAsyncHttpClient {
    private static final Pattern PLUS_CHARACTER_PATTERN = Pattern.compile("\\+");
    private static final String ENCODED_PLUS_CHARACTER = "%2B";
    private static final Pattern SPACE_CHARACTER_PATTERN = Pattern.compile(" ");
    private static final String ENCODED_SPACE_CHARACTER = "%20";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected HttpAsyncClient client;
    protected boolean closeClient;
    protected int socketTimeout;
    protected int connectTimeout;
    protected int connectionRequestTimeout;

    public ApacheHttpComponents5FlowableHttpClient(HttpClientConfig config) {
        HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom();
        PoolingAsyncClientConnectionManagerBuilder managerBuilder = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnTotal(500);
        if (config.isDisableCertVerify()) {
            try {
                SSLContextBuilder builder = SSLContextBuilder.create();
                builder.loadTrustMaterial(null, (TrustStrategy)TrustSelfSignedStrategy.INSTANCE);
                managerBuilder.setTlsStrategy((TlsStrategy)new DefaultClientTlsStrategy(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
            }
            catch (Exception e) {
                this.logger.error("Could not configure HTTP client SSL self signed strategy", (Throwable)e);
            }
        }
        int retryCount = 0;
        if (config.getRequestRetryLimit() > 0) {
            retryCount = config.getRequestRetryLimit();
        }
        httpClientBuilder.setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(retryCount, TimeValue.ZERO_MILLISECONDS));
        if (config.isUseSystemProperties()) {
            httpClientBuilder.useSystemProperties();
            managerBuilder.useSystemProperties();
        }
        httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)managerBuilder.build());
        CloseableHttpAsyncClient client = httpClientBuilder.build();
        client.start();
        this.client = client;
        this.closeClient = true;
        this.socketTimeout = config.getSocketTimeout();
        this.connectTimeout = config.getConnectTimeout();
        this.connectionRequestTimeout = config.getConnectionRequestTimeout();
    }

    public ApacheHttpComponents5FlowableHttpClient(HttpAsyncClient client, int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        this.client = client;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void close() {
        if (this.closeClient && this.client instanceof ModalCloseable) {
            ((ModalCloseable)this.client).close(CloseMode.GRACEFUL);
        }
    }

    @Override
    public AsyncExecutableHttpRequest prepareRequest(HttpRequest requestInfo) {
        try {
            AsyncRequestBuilder request;
            URI uri = this.createUri(requestInfo.getUrl());
            switch (requestInfo.getMethod()) {
                case "GET": {
                    request = AsyncRequestBuilder.get((URI)uri);
                    break;
                }
                case "POST": {
                    request = AsyncRequestBuilder.post((URI)uri);
                    this.setRequestEntity(requestInfo, request);
                    break;
                }
                case "PUT": {
                    request = AsyncRequestBuilder.put((URI)uri);
                    this.setRequestEntity(requestInfo, request);
                    break;
                }
                case "PATCH": {
                    request = AsyncRequestBuilder.patch((URI)uri);
                    this.setRequestEntity(requestInfo, request);
                    break;
                }
                case "DELETE": {
                    request = AsyncRequestBuilder.delete((URI)uri);
                    this.setRequestEntity(requestInfo, request);
                    break;
                }
                default: {
                    throw new FlowableException(requestInfo.getMethod() + " HTTP method not supported");
                }
            }
            if (requestInfo.getHttpHeaders() != null) {
                this.setHeaders(request, requestInfo.getHttpHeaders());
            }
            return new ApacheHttpComponentsExecutableHttpRequest(request.build(), this.createRequestConfig(requestInfo));
        }
        catch (URISyntaxException ex) {
            throw new FlowableException("Invalid URL exception occurred", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new FlowableException("IO exception occurred", (Throwable)ex);
        }
    }

    protected URI createUri(String url) throws URISyntaxException {
        String uri = SPACE_CHARACTER_PATTERN.matcher(url).replaceAll(ENCODED_SPACE_CHARACTER);
        return new URI(PLUS_CHARACTER_PATTERN.matcher(uri).replaceAll(ENCODED_PLUS_CHARACTER));
    }

    protected void setRequestEntity(HttpRequest requestInfo, AsyncRequestBuilder requestBase) throws UnsupportedEncodingException {
        if (requestInfo.getBody() != null) {
            if (StringUtils.isNotEmpty((CharSequence)requestInfo.getBodyEncoding())) {
                requestBase.setEntity(AsyncEntityProducers.create((String)requestInfo.getBody(), (Charset)Charset.forName(requestInfo.getBodyEncoding())));
            } else {
                requestBase.setEntity(AsyncEntityProducers.create((String)requestInfo.getBody()));
            }
        } else if (requestInfo.getMultiValueParts() != null) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.LEGACY);
            for (MultiValuePart part : requestInfo.getMultiValueParts()) {
                String name = part.getName();
                Object value = part.getBody();
                if (value instanceof byte[]) {
                    entityBuilder.addBinaryBody(name, (byte[])value, ContentType.DEFAULT_BINARY, part.getFilename());
                    continue;
                }
                if (value instanceof String) {
                    entityBuilder.addTextBody(name, (String)value);
                    continue;
                }
                if (value == null) continue;
                throw new FlowableIllegalArgumentException("Value of type " + value.getClass() + " is not supported as multi part content");
            }
            try (HttpEntity multiPartEntity = entityBuilder.build();
                 ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)multiPartEntity.getContentLength());){
                multiPartEntity.writeTo((OutputStream)outputStream);
                requestBase.setEntity(outputStream.toByteArray(), ContentType.parse((CharSequence)multiPartEntity.getContentType()));
            }
            catch (IOException e) {
                throw new FlowableException("Cannot create multi part entity", (Throwable)e);
            }
        }
    }

    protected void setHeaders(AsyncRequestBuilder base, HttpHeaders headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                base.addHeader(headerName, headerValue);
            }
        }
    }

    protected RequestConfig createRequestConfig(HttpRequest request) {
        return RequestConfig.custom().setRedirectsEnabled(!request.isNoRedirects()).setResponseTimeout(request.getTimeout() == 0 ? (long)this.socketTimeout : (long)request.getTimeout(), TimeUnit.MILLISECONDS).setConnectTimeout((long)this.connectTimeout, TimeUnit.MILLISECONDS).setConnectionRequestTimeout((long)this.connectionRequestTimeout, TimeUnit.MILLISECONDS).build();
    }

    protected HttpResponse toFlowableHttpResponse(SimpleHttpResponse response) {
        HttpResponse responseInfo = new HttpResponse();
        responseInfo.setStatusCode(response.getCode());
        responseInfo.setReason(response.getReasonPhrase());
        responseInfo.setProtocol((response.getVersion() != null ? response.getVersion() : HttpVersion.HTTP_1_1).toString());
        HttpHeaders headers = null;
        Iterator headerIterator = response.headerIterator();
        while (headerIterator.hasNext()) {
            if (headers == null) {
                headers = new HttpHeaders();
            }
            Header header = (Header)headerIterator.next();
            headers.add(header.getName(), header.getValue());
        }
        responseInfo.setHttpHeaders(headers);
        SimpleBody body = response.getBody();
        if (body != null) {
            if (body.isText()) {
                responseInfo.setBody(body.getBodyText());
            } else {
                try {
                    responseInfo.setBody(EntityUtils.toString((HttpEntity)new ByteArrayEntity(body.getBodyBytes(), body.getContentType())));
                }
                catch (IOException | ParseException e) {
                    throw new FlowableException("Failed to read body");
                }
            }
        }
        return responseInfo;
    }

    protected class ApacheHttpComponentsExecutableHttpRequest
    implements AsyncExecutableHttpRequest {
        protected final AsyncRequestProducer request;
        protected final RequestConfig requestConfig;

        public ApacheHttpComponentsExecutableHttpRequest(AsyncRequestProducer request, RequestConfig requestConfig) {
            this.request = request;
            this.requestConfig = requestConfig;
        }

        @Override
        public CompletableFuture<HttpResponse> callAsync() {
            final CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(this.requestConfig);
            ApacheHttpComponents5FlowableHttpClient.this.client.execute(this.request, (AsyncResponseConsumer)SimpleResponseConsumer.create(), null, (HttpContext)context, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse result) {
                    responseFuture.complete(ApacheHttpComponents5FlowableHttpClient.this.toFlowableHttpResponse(result));
                }

                public void failed(Exception ex) {
                    responseFuture.completeExceptionally(ex);
                }

                public void cancelled() {
                    responseFuture.cancel(true);
                }
            });
            return responseFuture;
        }
    }
}

