/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.springframework.transaction.annotation.Transactional;

public class TemplateUtils {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;

    protected static Attr evaluateAttr(Attr template, MapContext jexlContext) {
        Attr result = new Attr();
        result.setSchema(template.getSchema());
        if (template.getValues() != null && !template.getValues().isEmpty()) {
            template.getValues().forEach(value -> {
                String evaluated = JexlUtils.evaluate((String)value, (JexlContext)jexlContext).toString();
                if (StringUtils.isNotBlank((CharSequence)evaluated)) {
                    result.getValues().add(evaluated);
                }
            });
        }
        return result;
    }

    protected static void fill(RealmMember realmMember, RealmMember template) {
        Attr evaluated;
        String evaluated2;
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext((Object)realmMember, (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getVirAttrs(), (JexlContext)jexlContext);
        if (template.getRealm() != null && StringUtils.isNotBlank((CharSequence)(evaluated2 = JexlUtils.evaluate((String)template.getRealm(), (JexlContext)jexlContext).toString()))) {
            realmMember.setRealm(evaluated2);
        }
        Map currentAttrMap = EntityTOUtils.buildAttrMap((Collection)realmMember.getPlainAttrs());
        for (Attr templatePlainAttr : template.getPlainAttrs()) {
            if (templatePlainAttr.getValues().isEmpty() || currentAttrMap.containsKey(templatePlainAttr.getSchema()) && !((Attr)currentAttrMap.get(templatePlainAttr.getSchema())).getValues().isEmpty() || (evaluated = TemplateUtils.evaluateAttr(templatePlainAttr, jexlContext)).getValues().isEmpty()) continue;
            realmMember.getPlainAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)realmMember.getDerAttrs());
        for (Attr templateDerAttr : template.getDerAttrs()) {
            if (currentAttrMap.containsKey(templateDerAttr.getSchema())) continue;
            realmMember.getDerAttrs().add(templateDerAttr);
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)realmMember.getVirAttrs());
        for (Attr templateVirAttr : template.getVirAttrs()) {
            if (templateVirAttr.getValues().isEmpty() || currentAttrMap.containsKey(templateVirAttr.getSchema()) && !((Attr)currentAttrMap.get(templateVirAttr.getSchema())).getValues().isEmpty() || (evaluated = TemplateUtils.evaluateAttr(templateVirAttr, jexlContext)).getValues().isEmpty()) continue;
            realmMember.getVirAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        realmMember.getResources().addAll(template.getResources());
        realmMember.getAuxClasses().addAll(template.getAuxClasses());
    }

    protected static void fillRelationships(GroupableRelatableTO any, GroupableRelatableTO template) {
        template.getRelationships().stream().filter(relationship -> any.getRelationship(relationship.getOtherEndKey(), relationship.getOtherEndKey()).isEmpty()).forEachOrdered(relationship -> any.getRelationships().add(relationship));
    }

    protected static void fillMemberships(GroupableRelatableTO any, GroupableRelatableTO template) {
        template.getMemberships().stream().filter(membership -> any.getMembership(membership.getGroupKey()).isEmpty()).forEachOrdered(membership -> any.getMemberships().add(membership));
    }

    public TemplateUtils(UserDAO userDAO, GroupDAO groupDAO) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
    }

    @Transactional(readOnly=true)
    public void apply(RealmMember realmMember, Optional<? extends AnyTemplate> template) {
        template.ifPresent(anyTemplate -> this.apply(realmMember, anyTemplate.get()));
    }

    @Transactional(readOnly=true)
    public void apply(RealmMember realmMember, AnyTO template) {
        TemplateUtils.fill(realmMember, (RealmMember)template);
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext((Object)realmMember, (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getVirAttrs(), (JexlContext)jexlContext);
        if (template instanceof AnyObjectTO) {
            TemplateUtils.fillRelationships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)template);
            TemplateUtils.fillMemberships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)template);
        } else if (template instanceof UserTO) {
            String evaluated;
            if (StringUtils.isNotBlank((CharSequence)((UserTO)template).getUsername()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate((String)((UserTO)template).getUsername(), (JexlContext)jexlContext).toString()))) {
                if (realmMember instanceof UserTO) {
                    ((UserTO)realmMember).setUsername(evaluated);
                } else if (realmMember instanceof UserCR) {
                    ((UserCR)realmMember).setUsername(evaluated);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)((UserTO)template).getPassword()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate((String)((UserTO)template).getPassword(), (JexlContext)jexlContext).toString()))) {
                if (realmMember instanceof UserTO) {
                    ((UserTO)realmMember).setPassword(evaluated);
                } else if (realmMember instanceof UserCR) {
                    ((UserCR)realmMember).setPassword(evaluated);
                }
            }
            TemplateUtils.fillRelationships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)template);
            TemplateUtils.fillMemberships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)template);
            if (realmMember instanceof UserTO) {
                ((UserTO)realmMember).getRoles().addAll(((UserTO)template).getRoles());
            } else if (realmMember instanceof UserCR) {
                ((UserCR)realmMember).getRoles().addAll(((UserTO)template).getRoles());
            }
        } else if (template instanceof GroupTO) {
            Group groupOwner;
            User userOwner;
            String evaluated;
            if (StringUtils.isNotBlank((CharSequence)((GroupTO)template).getName()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate((String)((GroupTO)template).getName(), (JexlContext)jexlContext).toString()))) {
                if (realmMember instanceof GroupTO) {
                    ((GroupTO)realmMember).setName(evaluated);
                } else if (realmMember instanceof GroupCR) {
                    ((GroupCR)realmMember).setName(evaluated);
                }
            }
            if (((GroupTO)template).getUserOwner() != null && (userOwner = (User)this.userDAO.find(((GroupTO)template).getUserOwner())) != null) {
                if (realmMember instanceof GroupTO) {
                    ((GroupTO)realmMember).setUserOwner(userOwner.getKey());
                } else if (realmMember instanceof GroupCR) {
                    ((GroupCR)realmMember).setUserOwner(userOwner.getKey());
                }
            }
            if (((GroupTO)template).getGroupOwner() != null && (groupOwner = (Group)this.groupDAO.find(((GroupTO)template).getGroupOwner())) != null) {
                if (realmMember instanceof GroupTO) {
                    ((GroupTO)realmMember).setGroupOwner(groupOwner.getKey());
                } else if (realmMember instanceof GroupCR) {
                    ((GroupCR)realmMember).setGroupOwner(groupOwner.getKey());
                }
            }
        }
    }

    public static void check(Map<String, AnyTO> templates, ClientExceptionType clientExceptionType) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)clientExceptionType);
        templates.values().forEach(value -> {
            GroupTO template;
            value.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty() && !JexlUtils.isExpressionValid((String)((String)attrTO.getValues().get(0)))).forEachOrdered(attrTO -> sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0)));
            value.getVirAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty() && !JexlUtils.isExpressionValid((String)((String)attrTO.getValues().get(0)))).forEachOrdered(attrTO -> sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0)));
            if (value instanceof UserTO) {
                UserTO template2 = (UserTO)value;
                if (StringUtils.isNotBlank((CharSequence)template2.getUsername()) && !JexlUtils.isExpressionValid((String)template2.getUsername())) {
                    sce.getElements().add("Invalid JEXL: " + template2.getUsername());
                }
                if (StringUtils.isNotBlank((CharSequence)template2.getPassword()) && !JexlUtils.isExpressionValid((String)template2.getPassword())) {
                    sce.getElements().add("Invalid JEXL: " + template2.getPassword());
                }
            } else if (value instanceof GroupTO && StringUtils.isNotBlank((CharSequence)(template = (GroupTO)value).getName()) && !JexlUtils.isExpressionValid((String)template.getName())) {
                sce.getElements().add("Invalid JEXL: " + template.getName());
            }
        });
        if (!sce.isEmpty()) {
            throw sce;
        }
    }
}

