/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class DBPasswordPropagationActions
implements PropagationActions {
    protected static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    protected UserDAO userDAO;

    protected String getCipherAlgorithm(ConnInstance connInstance) {
        Optional<ConnConfProperty> cipherAlgorithm = connInstance.getConf().stream().filter(property -> "cipherAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty()).findFirst();
        return cipherAlgorithm.isPresent() ? (String)cipherAlgorithm.get().getValues().get(0) : CLEARTEXT;
    }

    protected boolean cipherAlgorithmMatches(String connectorAlgorithm, CipherAlgorithm userAlgorithm) {
        if (userAlgorithm == null) {
            return false;
        }
        if (connectorAlgorithm.equals(userAlgorithm.name())) {
            return true;
        }
        return "SHA1".equals(connectorAlgorithm) && "SHA".equals(userAlgorithm.name());
    }

    @Transactional(readOnly=true)
    public void before(PropagationTaskInfo taskInfo) {
        if (AnyTypeKind.USER == taskInfo.getAnyTypeKind()) {
            User user = (User)this.userDAO.find(taskInfo.getEntityKey());
            PropagationData data = taskInfo.getPropagationData();
            if (user != null && user.getPassword() != null && data.getAttributes() != null) {
                Set attrs = data.getAttributes();
                Attribute missing = AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)attrs);
                ConnInstance connInstance = taskInfo.getResource().getConnector();
                if (missing != null && missing.getValue() != null && missing.getValue().size() == 1 && missing.getValue().get(0).equals(OperationalAttributes.PASSWORD_NAME) && this.cipherAlgorithmMatches(this.getCipherAlgorithm(connInstance), user.getCipherAlgorithm())) {
                    Attribute passwordAttribute = AttributeBuilder.buildPassword((GuardedString)new GuardedString(user.getPassword().toCharArray()));
                    attrs.add(passwordAttribute);
                    attrs.remove(missing);
                    Attribute hashedPasswordAttribute = AttributeBuilder.build((String)AttributeUtil.createSpecialName((String)"HASHED_PASSWORD"), (Object[])new Object[]{Boolean.TRUE});
                    attrs.add(hashedPasswordAttribute);
                }
            }
        }
    }
}

