/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class GroupDataBinderImpl
extends AbstractAnyDataBinder
implements GroupDataBinder {
    protected final SearchCondVisitor searchCondVisitor;

    public GroupDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmDAO realmDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, PlainAttrDAO plainAttrDAO, PlainAttrValueDAO plainAttrValueDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, SearchCondVisitor searchCondVisitor, PlainAttrValidationManager validator) {
        super(anyTypeDAO, realmDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, plainAttrDAO, plainAttrValueDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, virAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator);
        this.searchCondVisitor = searchCondVisitor;
    }

    protected void setDynMembership(Group group, AnyType anyType, String dynMembershipFIQL) {
        DynGroupMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.GROUP) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyType.getKind().name());
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.ANY_OBJECT && group.getADynMembership(anyType).isEmpty()) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(ADynGroupMembership.class);
            dynMembership.setGroup(group);
            ((ADynGroupMembership)dynMembership).setAnyType(anyType);
            group.add((ADynGroupMembership)dynMembership);
        } else if (anyType.getKind() == AnyTypeKind.USER && group.getUDynMembership() == null) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(UDynGroupMembership.class);
            dynMembership.setGroup(group);
            group.setUDynMembership((UDynGroupMembership)dynMembership);
        } else {
            dynMembership = anyType.getKind() == AnyTypeKind.ANY_OBJECT ? (DynGroupMembership)group.getADynMembership(anyType).get() : group.getUDynMembership();
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public void create(Group group, GroupCR groupCR) {
        User owner;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (groupCR.getName() == null) {
            LOG.error("No name specified for this group");
            invalidGroups.getElements().add("No name specified for this group");
        } else {
            group.setName(groupCR.getName());
        }
        Realm realm = this.realmDAO.findByFullPath(groupCR.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + groupCR.getRealm());
            scce.addException(noRealm);
        }
        group.setRealm(realm);
        this.fill((Any)group, (AnyCR)groupCR, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        if (groupCR.getUserOwner() != null) {
            owner = (User)this.userDAO.find(groupCR.getUserOwner());
            if (owner == null) {
                LOG.warn("Ignoring invalid user specified as owner: {}", (Object)groupCR.getUserOwner());
            } else {
                group.setUserOwner(owner);
            }
        }
        if (groupCR.getGroupOwner() != null) {
            owner = (Group)this.groupDAO.find(groupCR.getGroupOwner());
            if (owner == null) {
                LOG.warn("Ignoring invalid group specified as owner: {}", (Object)groupCR.getGroupOwner());
            } else {
                group.setGroupOwner((Group)owner);
            }
        }
        if (groupCR.getUDynMembershipCond() != null) {
            this.setDynMembership(group, this.anyTypeDAO.findUser(), groupCR.getUDynMembershipCond());
        }
        groupCR.getADynMembershipConds().forEach((type, fiql) -> {
            AnyType anyType = this.anyTypeDAO.find(type);
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), type);
            } else {
                this.setDynMembership(group, anyType, (String)fiql);
            }
        });
        groupCR.getTypeExtensions().forEach(typeExtTO -> {
            AnyType anyType = this.anyTypeDAO.find(typeExtTO.getAnyType());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType());
            } else {
                TypeExtension typeExt = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
                typeExt.setAnyType(anyType);
                typeExt.setGroup(group);
                group.add(typeExt);
                typeExtTO.getAuxClasses().forEach(name -> {
                    AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(name);
                    if (anyTypeClass == null) {
                        LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), name);
                    } else {
                        typeExt.add(anyTypeClass);
                    }
                });
                if (typeExt.getAuxClasses().isEmpty()) {
                    group.getTypeExtensions().remove(typeExt);
                    typeExt.setGroup(null);
                }
            }
        });
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource<String> update(Group toBeUpdated, GroupUR groupUR) {
        AnyType anyType;
        Group group = (Group)this.groupDAO.save((Any)toBeUpdated);
        Map<String, ConnObject> beforeOnResources = this.onResources((Any<?>)group, this.groupDAO.findAllResourceKeys(group.getKey()), null, false);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.setRealm((Any<?>)group, (AnyUR)groupUR);
        if (groupUR.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)groupUR.getName().getValue()))) {
            group.setName((String)groupUR.getName().getValue());
        }
        PropagationByResource ownerPropByRes = new PropagationByResource();
        if (groupUR.getUserOwner() != null) {
            if (groupUR.getUserOwner().getValue() == null) {
                if (group.getUserOwner() != null) {
                    group.setUserOwner(null);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            } else {
                User userOwner = (User)this.userDAO.find((String)groupUR.getUserOwner().getValue());
                if (userOwner == null) {
                    LOG.debug("Unable to find user owner for group {} by key {}", (Object)group.getKey(), groupUR.getUserOwner().getValue());
                    group.setUserOwner(null);
                } else {
                    group.setUserOwner(userOwner);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            }
        }
        if (groupUR.getGroupOwner() != null) {
            if (groupUR.getGroupOwner().getValue() == null) {
                if (group.getGroupOwner() != null) {
                    group.setGroupOwner(null);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            } else {
                Group groupOwner = (Group)this.groupDAO.find((String)groupUR.getGroupOwner().getValue());
                if (groupOwner == null) {
                    LOG.debug("Unable to find group owner for group {} by key {}", (Object)group.getKey(), groupUR.getGroupOwner().getValue());
                    group.setGroupOwner(null);
                } else {
                    group.setGroupOwner(groupOwner);
                    ownerPropByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            }
        }
        this.fill((Any)group, (AnyUR)groupUR, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        group = (Group)this.groupDAO.save((Any)group);
        if (groupUR.getUDynMembershipCond() == null) {
            if (group.getUDynMembership() != null) {
                group.getUDynMembership().setGroup(null);
                group.setUDynMembership(null);
                this.groupDAO.clearUDynMembers(group);
            }
        } else {
            this.setDynMembership(group, this.anyTypeDAO.findUser(), groupUR.getUDynMembershipCond());
        }
        Iterator<Object> itor = group.getADynMemberships().iterator();
        while (itor.hasNext()) {
            ADynGroupMembership aDynGroupMembership = (ADynGroupMembership)itor.next();
            aDynGroupMembership.setGroup(null);
            itor.remove();
        }
        this.groupDAO.clearADynMembers(group);
        for (Map.Entry entry : groupUR.getADynMembershipConds().entrySet()) {
            anyType = this.anyTypeDAO.find((String)entry.getKey());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), entry.getKey());
                continue;
            }
            this.setDynMembership(group, anyType, (String)entry.getValue());
        }
        group = this.groupDAO.saveAndRefreshDynMemberships(group);
        for (TypeExtensionTO typeExtensionTO : groupUR.getTypeExtensions()) {
            anyType = this.anyTypeDAO.find(typeExtensionTO.getAnyType());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtensionTO.getAnyType());
                continue;
            }
            TypeExtension typeExt2 = group.getTypeExtension(anyType).orElse(null);
            if (typeExt2 == null) {
                typeExt2 = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
                typeExt2.setAnyType(anyType);
                typeExt2.setGroup(group);
                group.add(typeExt2);
            }
            for (String name : typeExtensionTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass2 = this.anyTypeClassDAO.find(name);
                if (anyTypeClass2 == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)name);
                    continue;
                }
                typeExt2.add(anyTypeClass2);
            }
            typeExt2.getAuxClasses().removeIf(anyTypeClass -> !typeExtTO.getAuxClasses().contains(anyTypeClass.getKey()));
            if (!typeExt2.getAuxClasses().isEmpty()) continue;
            group.getTypeExtensions().remove(typeExt2);
            typeExt2.setGroup(null);
        }
        group.getTypeExtensions().removeIf(typeExt -> groupUR.getTypeExtension(typeExt.getAnyType().getKey()).isEmpty());
        if (scce.hasExceptions()) {
            throw scce;
        }
        group = (Group)this.groupDAO.save((Any)group);
        PropagationByResource<String> propByRes = this.propByRes(beforeOnResources, this.onResources((Any<?>)group, this.groupDAO.findAllResourceKeys(group.getKey()), null, false));
        propByRes.merge(ownerPropByRes);
        return propByRes;
    }

    public TypeExtensionTO getTypeExtensionTO(TypeExtension typeExt) {
        TypeExtensionTO typeExtTO = new TypeExtensionTO();
        typeExtTO.setAnyType(typeExt.getAnyType().getKey());
        typeExtTO.getAuxClasses().addAll(typeExt.getAuxClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
        return typeExtTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(Group group, boolean details) {
        GroupTO groupTO = new GroupTO();
        groupTO.setCreator(group.getCreator());
        groupTO.setCreationDate(group.getCreationDate());
        groupTO.setCreationContext(group.getCreationContext());
        groupTO.setLastModifier(group.getLastModifier());
        groupTO.setLastChangeDate(group.getLastChangeDate());
        groupTO.setLastChangeContext(group.getLastChangeContext());
        groupTO.setKey(group.getKey());
        groupTO.setName(group.getName());
        groupTO.setStatus(group.getStatus());
        if (group.getUserOwner() != null) {
            groupTO.setUserOwner(group.getUserOwner().getKey());
        }
        if (group.getGroupOwner() != null) {
            groupTO.setGroupOwner(group.getGroupOwner().getKey());
        }
        Map derAttrValues = this.derAttrHandler.getValues((Any)group);
        Map virAttrValues = details ? this.virAttrHandler.getValues((Any)group) : Collections.emptyMap();
        GroupDataBinderImpl.fillTO((AnyTO)groupTO, group.getRealm().getFullPath(), group.getAuxClasses(), group.getPlainAttrs(), derAttrValues, virAttrValues, group.getResources());
        groupTO.getDynRealms().addAll(this.groupDAO.findDynRealms(group.getKey()));
        groupTO.setStaticUserMembershipCount(this.groupDAO.countUMembers(group.getKey()));
        groupTO.setStaticAnyObjectMembershipCount(this.groupDAO.countAMembers(group.getKey()));
        groupTO.setDynamicUserMembershipCount(this.groupDAO.countUDynMembers(group));
        groupTO.setDynamicAnyObjectMembershipCount(this.groupDAO.countADynMembers(group));
        if (group.getUDynMembership() != null) {
            groupTO.setUDynMembershipCond(group.getUDynMembership().getFIQLCond());
        }
        group.getADynMemberships().forEach(memb -> groupTO.getADynMembershipConds().put(memb.getAnyType().getKey(), memb.getFIQLCond()));
        group.getTypeExtensions().forEach(typeExt -> groupTO.getTypeExtensions().add(this.getTypeExtensionTO((TypeExtension)typeExt)));
        return groupTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(String key) {
        return this.getGroupTO((Group)this.groupDAO.authFind(key), true);
    }

    protected static void populateTransitiveResources(Group group, Any<?> any, Map<String, PropagationByResource<String>> result) {
        PropagationByResource propByRes = new PropagationByResource();
        group.getResources().forEach(resource -> {
            if (!any.getResources().contains(resource)) {
                propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            }
            if (!propByRes.isEmpty()) {
                result.put(any.getKey(), propByRes);
            }
        });
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource<String>> findAnyObjectsWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource<String>> result = new HashMap<String, PropagationByResource<String>>();
        this.groupDAO.findAMemberships(group).forEach(membership -> GroupDataBinderImpl.populateTransitiveResources(group, membership.getLeftEnd(), result));
        return result;
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource<String>> findUsersWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource<String>> result = new HashMap<String, PropagationByResource<String>>();
        this.groupDAO.findUMemberships(group).forEach(membership -> GroupDataBinderImpl.populateTransitiveResources(group, membership.getLeftEnd(), result));
        return result;
    }
}

