/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConnConfPropSchema;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.utils.ConnPoolConfUtils;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnInstanceDataBinderImpl
implements ConnInstanceDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnInstanceDataBinder.class);
    protected final ConnIdBundleManager connIdBundleManager;
    protected final ConnInstanceDAO connInstanceDAO;
    protected final RealmDAO realmDAO;
    protected final EntityFactory entityFactory;

    public ConnInstanceDataBinderImpl(ConnIdBundleManager connIdBundleManager, ConnInstanceDAO connInstanceDAO, RealmDAO realmDAO, EntityFactory entityFactory) {
        this.connIdBundleManager = connIdBundleManager;
        this.connInstanceDAO = connInstanceDAO;
        this.realmDAO = realmDAO;
        this.entityFactory = entityFactory;
    }

    public ConnInstance getConnInstance(ConnInstanceTO connInstanceTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        if (connInstanceTO.getLocation() == null) {
            sce.getElements().add("location");
        }
        if (connInstanceTO.getBundleName() == null) {
            sce.getElements().add("bundlename");
        }
        if (connInstanceTO.getVersion() == null) {
            sce.getElements().add("bundleversion");
        }
        if (connInstanceTO.getConnectorName() == null) {
            sce.getElements().add("connectorname");
        }
        if (connInstanceTO.getConf().isEmpty()) {
            sce.getElements().add("configuration");
        }
        ConnInstance connInstance = (ConnInstance)this.entityFactory.newEntity(ConnInstance.class);
        connInstance.setBundleName(connInstanceTO.getBundleName());
        connInstance.setConnectorName(connInstanceTO.getConnectorName());
        connInstance.setVersion(connInstanceTO.getVersion());
        connInstance.setDisplayName(connInstanceTO.getDisplayName());
        connInstance.setConnRequestTimeout(connInstanceTO.getConnRequestTimeout());
        connInstance.getCapabilities().addAll(connInstanceTO.getCapabilities());
        if (connInstanceTO.getAdminRealm() != null) {
            connInstance.setAdminRealm(this.realmDAO.findByFullPath(connInstanceTO.getAdminRealm()));
        }
        if (connInstance.getAdminRealm() == null) {
            sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
        }
        if (connInstanceTO.getLocation() != null) {
            connInstance.setLocation(connInstanceTO.getLocation());
        }
        connInstance.setConf((Collection)connInstanceTO.getConf());
        if (connInstanceTO.getPoolConf() != null) {
            connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstanceTO.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return connInstance;
    }

    public ConnInstance update(ConnInstanceTO connInstanceTO) {
        ConnInstance connInstance = this.connInstanceDAO.authFind(connInstanceTO.getKey());
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + connInstanceTO.getKey() + "'");
        }
        connInstance.getCapabilities().clear();
        connInstance.getCapabilities().addAll(connInstanceTO.getCapabilities());
        if (connInstanceTO.getAdminRealm() != null) {
            Realm realm = this.realmDAO.findByFullPath(connInstanceTO.getAdminRealm());
            if (realm == null) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
                throw sce;
            }
            connInstance.setAdminRealm(realm);
        }
        if (connInstanceTO.getLocation() != null) {
            connInstance.setLocation(connInstanceTO.getLocation());
        }
        if (connInstanceTO.getBundleName() != null) {
            connInstance.setBundleName(connInstanceTO.getBundleName());
        }
        if (connInstanceTO.getVersion() != null) {
            connInstance.setVersion(connInstanceTO.getVersion());
        }
        if (connInstanceTO.getConnectorName() != null) {
            connInstance.setConnectorName(connInstanceTO.getConnectorName());
        }
        if (connInstanceTO.getConf() != null && !connInstanceTO.getConf().isEmpty()) {
            connInstance.setConf((Collection)connInstanceTO.getConf());
        }
        if (connInstanceTO.getDisplayName() != null) {
            connInstance.setDisplayName(connInstanceTO.getDisplayName());
        }
        if (connInstanceTO.getConnRequestTimeout() != null) {
            connInstance.setConnRequestTimeout(connInstanceTO.getConnRequestTimeout());
        }
        if (connInstanceTO.getPoolConf() == null) {
            connInstance.setPoolConf(null);
        } else {
            connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstanceTO.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        return connInstance;
    }

    public ConnConfPropSchema build(ConfigurationProperty property) {
        ConnConfPropSchema connConfPropSchema = new ConnConfPropSchema();
        connConfPropSchema.setName(property.getName());
        connConfPropSchema.setDisplayName(property.getDisplayName(property.getName()));
        connConfPropSchema.setHelpMessage(property.getHelpMessage(property.getName()));
        connConfPropSchema.setRequired(property.isRequired());
        connConfPropSchema.setType(property.getType().getName());
        connConfPropSchema.setOrder(((ConfigurationPropertyImpl)property).getOrder());
        connConfPropSchema.setConfidential(property.isConfidential());
        if (property.getValue() != null) {
            if (property.getValue().getClass().isArray()) {
                connConfPropSchema.getDefaultValues().addAll(List.of((Object[])property.getValue()));
            } else if (property.getValue() instanceof Collection) {
                connConfPropSchema.getDefaultValues().addAll((Collection)property.getValue());
            } else {
                connConfPropSchema.getDefaultValues().add(property.getValue());
            }
        }
        return connConfPropSchema;
    }

    public ConnInstanceTO getConnInstanceTO(ConnInstance connInstance) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setKey(connInstance.getKey());
        connInstanceTO.setBundleName(connInstance.getBundleName());
        connInstanceTO.setConnectorName(connInstance.getConnectorName());
        connInstanceTO.setVersion(connInstance.getVersion());
        connInstanceTO.setDisplayName(connInstance.getDisplayName());
        connInstanceTO.setConnRequestTimeout(connInstance.getConnRequestTimeout());
        connInstanceTO.setAdminRealm(connInstance.getAdminRealm().getFullPath());
        connInstanceTO.getCapabilities().addAll(connInstance.getCapabilities());
        connInstanceTO.getConf().addAll(connInstance.getConf());
        try {
            Pair info = this.connIdBundleManager.getConnectorInfo(connInstance);
            connInstanceTO.setLocation(((URI)info.getLeft()).toASCIIString());
            ConfigurationProperties properties = this.connIdBundleManager.getConfigurationProperties((ConnectorInfo)info.getRight());
            properties.getPropertyNames().forEach(propName -> {
                ConnConfPropSchema schema = this.build(properties.getProperty(propName));
                Optional<ConnConfProperty> property = connInstanceTO.getConf(propName);
                if (property.isEmpty()) {
                    property = Optional.of(new ConnConfProperty());
                    connInstanceTO.getConf().add(property.get());
                }
                ((ConnConfProperty)property.get()).setSchema(schema);
            });
        }
        catch (Exception e) {
            LOG.error("Could not get ConnId information for {} / {}#{}#{}", new Object[]{connInstance.getLocation(), connInstance.getBundleName(), connInstance.getConnectorName(), connInstance.getVersion(), e});
            connInstanceTO.setErrored(true);
            connInstanceTO.setLocation(connInstance.getLocation());
        }
        Collections.sort(connInstanceTO.getConf());
        if (connInstance.getPoolConf() != null && (connInstance.getPoolConf().getMaxIdle() != null || connInstance.getPoolConf().getMaxObjects() != null || connInstance.getPoolConf().getMaxWait() != null || connInstance.getPoolConf().getMinEvictableIdleTimeMillis() != null || connInstance.getPoolConf().getMinIdle() != null)) {
            ConnPoolConfTO poolConf = new ConnPoolConfTO();
            poolConf.setMaxIdle(connInstance.getPoolConf().getMaxIdle());
            poolConf.setMaxObjects(connInstance.getPoolConf().getMaxObjects());
            poolConf.setMaxWait(connInstance.getPoolConf().getMaxWait());
            poolConf.setMinEvictableIdleTimeMillis(connInstance.getPoolConf().getMinEvictableIdleTimeMillis());
            poolConf.setMinIdle(connInstance.getPoolConf().getMinIdle());
            connInstanceTO.setPoolConf(poolConf);
        }
        return connInstanceTO;
    }
}

