/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.oauth.AuthorizationUrlBuilder;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RedirectionActionBuilder
implements RedirectionActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OAuth20RedirectionActionBuilder.class);
    protected OAuth20Configuration configuration;
    protected IndirectClient client;

    public OAuth20RedirectionActionBuilder(OAuth20Configuration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(WebContext context, SessionStore sessionStore) {
        try {
            String state;
            if (this.configuration.isWithState()) {
                state = this.configuration.getStateGenerator().generateValue(context, sessionStore);
                logger.debug("save sessionState: {}", (Object)state);
                sessionStore.set(context, this.client.getStateSessionAttributeName(), (Object)state);
            } else {
                state = null;
            }
            OAuth20Service service = (OAuth20Service)this.configuration.buildService(context, this.client);
            String authorizationUrl = new AuthorizationUrlBuilder(service).state(state).additionalParams(this.configuration.getCustomParams()).build();
            logger.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)authorizationUrl));
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

