/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery.webfinger.userinfo;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class OidcRestfulWebFingerUserInfoRepository
implements OidcWebFingerUserInfoRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRestfulWebFingerUserInfoRepository.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().failOnUnknownProperties(false).build().toObjectMapper();
    private final RestEndpointProperties properties;

    @Override
    public Map<String, Object> findByEmailAddress(String email) {
        return this.findAccountViaRestApi(CollectionUtils.wrap((String)"email", (Object)email));
    }

    @Override
    public Map<String, Object> findByUsername(String username) {
        return this.findAccountViaRestApi(CollectionUtils.wrap((String)"username", (Object)username));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> findAccountViaRestApi(Map<String, String> headers) {
        HttpResponse response = null;
        try {
            headers.putAll(this.properties.getHeaders());
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(this.properties.getBasicAuthPassword()).basicAuthUsername(this.properties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)this.properties.getMethod().toUpperCase().trim())).url(this.properties.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            if (response != null && response.getEntity() != null && response.getStatusLine().getStatusCode() == 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                Map map = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
                HttpUtils.close((HttpResponse)response);
                return map;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return new HashMap<String, Object>(0);
    }

    @Generated
    public OidcRestfulWebFingerUserInfoRepository(RestEndpointProperties properties) {
        this.properties = properties;
    }
}

