/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import javax.servlet.Filter;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.JWTAuthenticationFilter;
import org.apache.syncope.core.spring.security.JWTAuthenticationProvider;
import org.apache.syncope.core.spring.security.MustChangePasswordFilter;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeAccessDeniedHandler;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetailsSource;
import org.apache.syncope.core.spring.security.SyncopeBasicAuthenticationEntryPoint;
import org.apache.syncope.core.spring.security.UsernamePasswordAuthenticationProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Configuration(proxyBeanMethods=false)
public class WebSecurityContext {
    private static final String ANONYMOUS_BEAN_KEY = "doesNotMatter";

    public WebSecurityContext() {
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
    }

    @Bean
    public HttpFirewall allowUrlEncodedSlashHttpFirewall() {
        DefaultHttpFirewall firewall = new DefaultHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        return firewall;
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer(HttpFirewall allowUrlEncodedSlashHttpFirewall) {
        return web -> web.httpFirewall(allowUrlEncodedSlashHttpFirewall);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider, JWTAuthenticationProvider jwtAuthenticationProvider, SecurityProperties securityProperties, ApplicationContext ctx) throws Exception {
        AuthenticationManager authenticationManager = (AuthenticationManager)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).authenticationProvider((AuthenticationProvider)usernamePasswordAuthenticationProvider).authenticationProvider((AuthenticationProvider)jwtAuthenticationProvider).build();
        SyncopeAuthenticationDetailsSource authenticationDetailsSource = new SyncopeAuthenticationDetailsSource();
        AnonymousAuthenticationProvider anonymousAuthenticationProvider = new AnonymousAuthenticationProvider(ANONYMOUS_BEAN_KEY);
        AnonymousAuthenticationFilter anonymousAuthenticationFilter = new AnonymousAuthenticationFilter(ANONYMOUS_BEAN_KEY, (Object)securityProperties.getAnonymousUser(), AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
        anonymousAuthenticationFilter.setAuthenticationDetailsSource((AuthenticationDetailsSource)authenticationDetailsSource);
        SyncopeBasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new SyncopeBasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName("Apache Syncope authentication");
        JWTAuthenticationFilter jwtAuthenticationFilter = new JWTAuthenticationFilter(authenticationManager, (AuthenticationEntryPoint)basicAuthenticationEntryPoint, authenticationDetailsSource, (AuthDataAccessor)ctx.getBean(AuthDataAccessor.class), (DefaultCredentialChecker)ctx.getBean(DefaultCredentialChecker.class));
        MustChangePasswordFilter mustChangePasswordFilter = new MustChangePasswordFilter();
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authenticationManager(authenticationManager).authorizeRequests().antMatchers(new String[]{"/**"})).permitAll().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).securityContext().securityContextRepository((SecurityContextRepository)new NullSecurityContextRepository()).and()).anonymous().authenticationProvider((AuthenticationProvider)anonymousAuthenticationProvider).authenticationFilter(anonymousAuthenticationFilter).and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)basicAuthenticationEntryPoint).authenticationDetailsSource((AuthenticationDetailsSource)authenticationDetailsSource).and()).exceptionHandling().accessDeniedHandler(this.accessDeniedHandler()).and()).addFilterBefore((Filter)jwtAuthenticationFilter, BasicAuthenticationFilter.class).addFilterBefore((Filter)mustChangePasswordFilter, FilterSecurityInterceptor.class).headers().disable()).csrf().disable();
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(SecurityProperties securityProperties, DomainOps domainOps, AuthDataAccessor dataAccessor, UserProvisioningManager provisioningManager, DefaultCredentialChecker credentialChecker) {
        return new UsernamePasswordAuthenticationProvider(domainOps, dataAccessor, provisioningManager, credentialChecker, securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public JWTAuthenticationProvider jwtAuthenticationProvider(AuthDataAccessor authDataAccessor) {
        return new JWTAuthenticationProvider(authDataAccessor);
    }

    @Bean
    public AccessDeniedHandler accessDeniedHandler() {
        return new SyncopeAccessDeniedHandler();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthDataAccessor authDataAccessor(SecurityProperties securityProperties, RealmDAO realmDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, RoleDAO roleDAO, DelegationDAO delegationDAO, ConnectorManager connectorManager, AuditManager auditManager, MappingManager mappingManager, ImplementationLookup implementationLookup) {
        return new AuthDataAccessor(securityProperties, realmDAO, userDAO, groupDAO, anySearchDAO, accessTokenDAO, confParamOps, roleDAO, delegationDAO, connectorManager, auditManager, mappingManager, implementationLookup);
    }
}

