/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.u2f;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.wa.U2FDevice;
import org.apache.syncope.common.rest.api.beans.U2FDeviceQuery;
import org.apache.syncope.common.rest.api.service.wa.U2FRegistrationService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WAU2FDeviceRepository
extends BaseU2FDeviceRepository {
    private static final Logger LOG = LoggerFactory.getLogger(WAU2FDeviceRepository.class);
    private final WARestClient waRestClient;
    private final OffsetDateTime expirationDate;

    public WAU2FDeviceRepository(CasConfigurationProperties casProperties, LoadingCache<String, String> requestStorage, WARestClient waRestClient, OffsetDateTime expirationDate) {
        super(casProperties, requestStorage, CipherExecutor.noOpOfSerializableToString());
        this.waRestClient = waRestClient;
        this.expirationDate = expirationDate;
    }

    private static U2FDeviceRegistration parseRegistrationRecord(String owner, U2FDevice device) {
        try {
            return U2FDeviceRegistration.builder().id(device.getId()).username(owner).record(device.getRecord()).createdDate(device.getIssueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices(String owner) {
        return this.getU2FService().search((U2FDeviceQuery)new U2FDeviceQuery.Builder().owner(owner).expirationDate(this.expirationDate).build()).getResult().stream().map(device -> WAU2FDeviceRepository.parseRegistrationRecord(owner, device)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        return this.getU2FService().search((U2FDeviceQuery)new U2FDeviceQuery.Builder().expirationDate(this.expirationDate).build()).getResult().stream().map(device -> WAU2FDeviceRepository.parseRegistrationRecord("", device)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration registration) {
        U2FDevice record = new U2FDevice.Builder().issueDate(OffsetDateTime.of(registration.getCreatedDate().atStartOfDay(), OffsetDateTime.now().getOffset())).record(registration.getRecord()).id(registration.getId()).build();
        this.getU2FService().create(registration.getUsername(), record);
        return WAU2FDeviceRepository.parseRegistrationRecord(registration.getUsername(), record);
    }

    public void deleteRegisteredDevice(U2FDeviceRegistration registration) {
        this.getU2FService().delete((U2FDeviceQuery)new U2FDeviceQuery.Builder().id(Long.valueOf(registration.getId())).build());
    }

    public boolean isDeviceRegisteredFor(String owner) {
        try {
            Collection<? extends U2FDeviceRegistration> devices = this.getRegisteredDevices(owner);
            return !CollectionUtils.isEmpty(devices);
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)owner);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public void clean() {
        this.getU2FService().delete((U2FDeviceQuery)new U2FDeviceQuery.Builder().expirationDate(this.expirationDate).build());
    }

    public void removeAll() {
        this.getU2FService().delete((U2FDeviceQuery)new U2FDeviceQuery.Builder().build());
    }

    private U2FRegistrationService getU2FService() {
        if (!WARestClient.isReady()) {
            throw new IllegalStateException("Syncope core is not yet ready");
        }
        return (U2FRegistrationService)this.waRestClient.getSyncopeClient().getService(U2FRegistrationService.class);
    }
}

