/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.saml.idp.metadata;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.SAML2IdPEntityTO;
import org.apache.syncope.common.rest.api.service.SAML2IdPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.support.saml.idp.metadata.generator.BaseSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulSamlIdPMetadataGenerator
extends BaseSamlIdPMetadataGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(RestfulSamlIdPMetadataGenerator.class);
    private final WARestClient restClient;

    public RestfulSamlIdPMetadataGenerator(SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext, WARestClient restClient) {
        super(samlIdPMetadataGeneratorConfigurationContext);
        this.restClient = restClient;
    }

    protected SamlIdPMetadataDocument finalizeMetadataDocument(SamlIdPMetadataDocument doc, Optional<SamlRegisteredService> registeredService) throws Exception {
        LOG.info("Generating new SAML2 IdP metadata document");
        doc.setAppliesTo("Syncope");
        SAML2IdPEntityTO entityTO = (SAML2IdPEntityTO)((SAML2IdPEntityTO.Builder)new SAML2IdPEntityTO.Builder().key(doc.getAppliesTo())).metadata(Base64.getEncoder().encodeToString(doc.getMetadata().getBytes(StandardCharsets.UTF_8))).build();
        if (doc.getSigningKey() != null) {
            entityTO.setSigningKey(Base64.getEncoder().encodeToString(doc.getSigningKey().getBytes(StandardCharsets.UTF_8)));
        }
        if (doc.getSigningCertificate() != null) {
            entityTO.setSigningCertificate(Base64.getEncoder().encodeToString(doc.getSigningCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        if (doc.getEncryptionKey() != null) {
            entityTO.setEncryptionKey(Base64.getEncoder().encodeToString(doc.getEncryptionKey().getBytes(StandardCharsets.UTF_8)));
        }
        if (doc.getEncryptionCertificate() != null) {
            entityTO.setEncryptionCertificate(Base64.getEncoder().encodeToString(doc.getEncryptionCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        ((SAML2IdPEntityService)this.getSyncopeClient().getService(SAML2IdPEntityService.class)).set(entityTO);
        return doc;
    }

    public Pair<String, String> buildSelfSignedEncryptionCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        return this.generateCertificateAndKey();
    }

    public Pair<String, String> buildSelfSignedSigningCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        return this.generateCertificateAndKey();
    }

    private SyncopeClient getSyncopeClient() {
        if (!WARestClient.isReady()) {
            LOG.info("Syncope client is not yet ready");
            throw new IllegalStateException("Syncope core is not yet ready to access requests");
        }
        return this.restClient.getSyncopeClient();
    }
}

