/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import lombok.Generated;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenUtils;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.util.RandomUtils;

public class OAuth20DefaultDeviceUserCodeFactory
implements OAuth20DeviceUserCodeFactory {
    protected final UniqueTicketIdGenerator deviceTokenIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicy;
    protected final int userCodeLength;
    protected final ServicesManager servicesManager;

    public OAuth20DeviceUserCode createDeviceUserCode(OAuth20DeviceToken deviceToken) {
        String userCode = this.generateDeviceUserCode(RandomUtils.randomAlphanumeric((int)this.userCodeLength));
        ExpirationPolicy expirationPolicyToUse = OAuth20DeviceTokenUtils.determineExpirationPolicyForService(this.servicesManager, this.expirationPolicy, deviceToken.getService());
        OAuth20DefaultDeviceUserCode deviceUserCode = new OAuth20DefaultDeviceUserCode(userCode, deviceToken.getId(), expirationPolicyToUse);
        deviceToken.assignUserCode((OAuth20DeviceUserCode)deviceUserCode);
        return deviceUserCode;
    }

    public String generateDeviceUserCode(String providedCode) {
        String prefix = "ODUC-";
        if (providedCode.startsWith("ODUC-")) {
            return providedCode;
        }
        return "ODUC-" + providedCode.toUpperCase();
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20DeviceUserCode.class;
    }

    @Generated
    public OAuth20DefaultDeviceUserCodeFactory(UniqueTicketIdGenerator deviceTokenIdGenerator, ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicy, int userCodeLength, ServicesManager servicesManager) {
        this.deviceTokenIdGenerator = deviceTokenIdGenerator;
        this.expirationPolicy = expirationPolicy;
        this.userCodeLength = userCodeLength;
        this.servicesManager = servicesManager;
    }
}

