/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AuthorizeEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizeEndpointController.class);

    public OAuth20AuthorizeEndpointController(T oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    private static Optional<OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder> toAuthorizationRequest(OAuthRegisteredService registeredService, JEEContext context, Service service, Authentication authentication, OAuth20AuthorizationResponseBuilder builder) {
        return builder.toAuthorizationRequest((WebContext)context, authentication, service, registeredService);
    }

    @GetMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv;
        ModelAndView mv2;
        JEEContext webContext = new JEEContext(request, response);
        Set prompts = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveSupportedPromptValues((WebContext)webContext);
        Set requestedPrompt = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveRequestedPromptValues((WebContext)webContext);
        if (!requestedPrompt.isEmpty() && !requestedPrompt.equals(prompts)) {
            return OAuth20Utils.writeError(response, "invalid_request", "Unsupported prompt parameter value");
        }
        this.ensureSessionReplicationIsAutoconfiguredIfNeedBe(request);
        JEEContext context = new JEEContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        if (context.getRequestAttribute("error").isPresent() && !(mv2 = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthInvalidAuthorizationResponseBuilder().build(context)).isEmpty() && mv2.hasView()) {
            return mv2;
        }
        String clientId = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveRequestParameter((WebContext)context, "client_id").map(String::valueOf).orElse("");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((String)clientId, (RegisteredService)registeredService);
        if (this.isRequestAuthenticated(manager, (WebContext)context, registeredService) && !(mv = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getConsentApprovalViewResolver().resolve((WebContext)context, registeredService)).isEmpty() && mv.hasView()) {
            LOGGER.debug("Redirecting to consent-approval view with model [{}]", (Object)mv.getModel());
            return mv;
        }
        return this.redirectToCallbackRedirectUrl(manager, registeredService, context);
    }

    @PostMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequestPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    protected boolean isRequestAuthenticated(ProfileManager manager, WebContext context, OAuthRegisteredService registeredService) {
        return manager.getProfile().isPresent();
    }

    protected void ensureSessionReplicationIsAutoconfiguredIfNeedBe(HttpServletRequest request) {
        SessionReplicationProperties replicationProps = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getPac4j().getCore().getSessionReplication();
        boolean cookieAutoconfigured = replicationProps.getCookie().isAutoConfigureCookiePath();
        if (replicationProps.isReplicateSessions() && cookieAutoconfigured) {
            String contextPath = request.getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            String path = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator().getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for OAuth distributed session cookie generator to: [{}]", cookiePath);
                ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator().setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("OAuth distributed cookie domain is [{}] with path [{}]", (Object)((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator().getCookieDomain(), (Object)path);
            }
        }
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager(), clientId);
    }

    protected ModelAndView redirectToCallbackRedirectUrl(ProfileManager manager, OAuthRegisteredService registeredService, JEEContext context) {
        UserProfile profile = (UserProfile)manager.getProfile().orElseThrow(() -> new IllegalArgumentException("Unable to locate authentication profile"));
        Service service = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAuthenticationBuilder().buildService(registeredService, (WebContext)context, false);
        LOGGER.trace("Created service [{}] based on registered service [{}]", (Object)service, (Object)registeredService);
        Authentication authentication = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAuthenticationBuilder().build(profile, registeredService, (WebContext)context, service);
        LOGGER.trace("Created OAuth authentication [{}] for service [{}]", (Object)authentication, (Object)service);
        try {
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
            AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            accessResult.throwExceptionIfNeeded();
            ModelAndView modelAndView = this.buildAuthorizationForRequest(registeredService, context, service, authentication);
            return Optional.ofNullable(modelAndView).filter(ModelAndView::hasView).orElseGet(() -> {
                LOGGER.trace("No explicit view was defined as part of the authorization response");
                return null;
            });
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return OAuth20Utils.produceUnauthorizedErrorView(HttpStatus.FORBIDDEN);
        }
    }

    protected ModelAndView buildAuthorizationForRequest(OAuthRegisteredService registeredService, JEEContext context, Service service, Authentication authentication) {
        List registeredBuilders = (List)((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthAuthorizationResponseBuilders().getObject();
        OAuth20AuthorizationRequest authzRequest = ((OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder)registeredBuilders.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<OAuth20AuthorizationResponseBuilder>)OrderComparator.INSTANCE).map(builder -> OAuth20AuthorizeEndpointController.toAuthorizationRequest(registeredService, context, service, authentication, builder)).filter(Objects::nonNull).filter(Optional::isPresent).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to build authorization request")).get()).build();
        AccessTokenRequestContext payload = Optional.ofNullable(authzRequest.getAccessTokenRequest()).orElseGet(Unchecked.supplier(() -> this.prepareAccessTokenRequestContext(authzRequest, registeredService, context, service, authentication)));
        return registeredBuilders.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<OAuth20AuthorizationResponseBuilder>)OrderComparator.INSTANCE).filter(b -> b.supports(authzRequest)).findFirst().map(Unchecked.function(builder -> {
            if (authzRequest.isSingleSignOnSessionRequired() && payload.getTicketGrantingTicket() == null) {
                String message = String.format("Missing ticket-granting-ticket for client id [%s] and service [%s]", authzRequest.getClientId(), registeredService.getName());
                LOGGER.error(message);
                return OAuth20Utils.produceErrorView((Exception)new PreventedException(message));
            }
            return builder.build(payload);
        })).orElseGet(() -> OAuth20Utils.produceErrorView((Exception)new PreventedException("Could not build the callback response")));
    }

    protected AccessTokenRequestContext prepareAccessTokenRequestContext(OAuth20AuthorizationRequest authzRequest, OAuthRegisteredService registeredService, JEEContext context, Service service, Authentication authentication) throws Exception {
        AccessTokenRequestContext.AccessTokenRequestContextBuilder payloadBuilder = AccessTokenRequestContext.builder();
        if (authzRequest.isSingleSignOnSessionRequired()) {
            TicketGrantingTicket tgt = ((OAuth20ConfigurationContext)this.getConfigurationContext()).fetchTicketGrantingTicketFrom(context);
            payloadBuilder = payloadBuilder.ticketGrantingTicket(tgt);
        }
        String redirectUri = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveRequestParameter((WebContext)context, "redirect_uri").map(String::valueOf).orElse("");
        String grantType = context.getRequestParameter("grant_type").map(String::valueOf).orElseGet(() -> ((OAuth20GrantTypes)OAuth20GrantTypes.AUTHORIZATION_CODE).getType()).toUpperCase();
        Set scopes = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveRequestScopes((WebContext)context);
        String codeChallenge = context.getRequestParameter("code_challenge").map(String::valueOf).orElse("");
        List challengeMethodsSupported = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc().getDiscovery().getCodeChallengeMethodsSupported();
        String codeChallengeMethod = context.getRequestParameter("code_challenge_method").map(String::valueOf).filter(challengeMethodsSupported::contains).orElse("").toUpperCase();
        UserProfile userProfile = OAuth20Utils.getAuthenticatedUserProfile((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        Map claims = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveRequestClaims((WebContext)context);
        AccessTokenRequestContext holder = payloadBuilder.service(service).authentication(authentication).registeredService(registeredService).grantType(((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveGrantType((WebContext)context)).responseType(((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveResponseType((WebContext)context)).codeChallenge(codeChallenge).codeChallengeMethod(codeChallengeMethod).scopes(scopes).clientId(authzRequest.getClientId()).redirectUri(redirectUri).userProfile(userProfile).claims(claims).responseMode(((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveResponseModeType((WebContext)context)).build();
        context.getRequestParameters().keySet().forEach(key -> context.getRequestParameter(key).ifPresent(value -> holder.getParameters().put(key, value)));
        LOGGER.debug("Building authorization response for grant type [{}] with scopes [{}] for client id [{}]", new Object[]{grantType, scopes, authzRequest.getClientId()});
        return holder;
    }
}

