/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.audit;

import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;

public class SamlRequestAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        if (returnValue instanceof Pair) {
            return this.getAuditResourceFromSamlRequest((Pair)returnValue);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private String[] getAuditResourceFromSamlRequest(Pair result) {
        XMLObject returnValue = (XMLObject)result.getLeft();
        if (returnValue instanceof AuthnRequest) {
            return this.getAuditResourceFromSamlAuthnRequest((AuthnRequest)returnValue);
        }
        if (returnValue instanceof LogoutRequest) {
            return this.getAuditResourceFromSamlLogoutRequest((LogoutRequest)returnValue);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private String[] getAuditResourceFromSamlLogoutRequest(LogoutRequest returnValue) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("issuer", returnValue.getIssuer().getValue());
        return new String[]{this.auditFormat.serialize(values)};
    }

    private String[] getAuditResourceFromSamlAuthnRequest(AuthnRequest returnValue) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("issuer", returnValue.getIssuer().getValue());
        values.put("binding", returnValue.getProtocolBinding());
        return new String[]{this.auditFormat.serialize(values)};
    }
}

