/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets.reconciliation;

import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.syncope.client.console.widgets.reconciliation.Any;
import org.apache.syncope.client.console.widgets.reconciliation.Anys;
import org.apache.syncope.client.console.widgets.reconciliation.Misaligned;
import org.apache.syncope.client.console.widgets.reconciliation.Missing;
import org.apache.syncope.client.console.widgets.reconciliation.ReconciliationReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;

public final class ReconciliationReportParser {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    public static ReconciliationReport parse(OffsetDateTime run, InputStream in) throws XMLStreamException, NumberFormatException {
        XMLStreamReader streamReader = XML_INPUT_FACTORY.createXMLStreamReader(in);
        streamReader.nextTag();
        streamReader.nextTag();
        streamReader.nextTag();
        ReconciliationReport report = new ReconciliationReport(run);
        ArrayList<Missing> missing = new ArrayList<Missing>();
        ArrayList<Misaligned> misaligned = new ArrayList<Misaligned>();
        HashSet onSyncope = null;
        HashSet onResource = null;
        Any user = null;
        Any group = null;
        Any anyObject = null;
        String lastAnyType = null;
        while (streamReader.hasNext()) {
            if (streamReader.isStartElement()) {
                switch (streamReader.getLocalName()) {
                    case "users": {
                        Anys users = new Anys();
                        users.setTotal(Integer.parseInt(streamReader.getAttributeValue("", "total")));
                        report.setUsers(users);
                        break;
                    }
                    case "user": {
                        user = new Any();
                        user.setType(AnyTypeKind.USER.name());
                        user.setKey(streamReader.getAttributeValue("", "key"));
                        user.setName(streamReader.getAttributeValue("", "username"));
                        report.getUsers().getAnys().add(user);
                        break;
                    }
                    case "groups": {
                        Anys groups = new Anys();
                        groups.setTotal(Integer.parseInt(streamReader.getAttributeValue("", "total")));
                        report.setGroups(groups);
                        break;
                    }
                    case "group": {
                        group = new Any();
                        group.setType(AnyTypeKind.GROUP.name());
                        group.setKey(streamReader.getAttributeValue("", "key"));
                        group.setName(streamReader.getAttributeValue("", "groupName"));
                        report.getGroups().getAnys().add(group);
                        break;
                    }
                    case "anyObjects": {
                        lastAnyType = streamReader.getAttributeValue("", "type");
                        Anys anyObjects = new Anys();
                        anyObjects.setAnyType(lastAnyType);
                        anyObjects.setTotal(Integer.parseInt(streamReader.getAttributeValue("", "total")));
                        report.getAnyObjects().add(anyObjects);
                        break;
                    }
                    case "anyObject": {
                        anyObject = new Any();
                        anyObject.setType(lastAnyType);
                        anyObject.setKey(streamReader.getAttributeValue("", "key"));
                        String anyType = lastAnyType;
                        Optional<Anys> anyReport = report.getAnyObjects().stream().filter(anys -> anyType.equals(anys.getAnyType())).findFirst();
                        if (!anyReport.isPresent()) break;
                        anyReport.get().getAnys().add(anyObject);
                        break;
                    }
                    case "missing": {
                        missing.add(new Missing(streamReader.getAttributeValue("", "resource"), streamReader.getAttributeValue("", "connObjectKeyValue")));
                        break;
                    }
                    case "misaligned": {
                        misaligned.add(new Misaligned(streamReader.getAttributeValue("", "resource"), streamReader.getAttributeValue("", "connObjectKeyValue"), streamReader.getAttributeValue("", "name")));
                        break;
                    }
                    case "onSyncope": {
                        onSyncope = new HashSet();
                        break;
                    }
                    case "onResource": {
                        onResource = new HashSet();
                        break;
                    }
                    case "value": {
                        Set set = Optional.ofNullable(onSyncope).orElse(onResource);
                        set.add(streamReader.getElementText());
                        break;
                    }
                }
            } else if (streamReader.isEndElement()) {
                switch (streamReader.getLocalName()) {
                    case "user": {
                        Optional.ofNullable(user).ifPresent(u -> {
                            u.getMissing().addAll(missing);
                            u.getMisaligned().addAll(misaligned);
                        });
                        missing.clear();
                        misaligned.clear();
                        break;
                    }
                    case "group": {
                        Optional.ofNullable(group).ifPresent(g -> {
                            g.getMissing().addAll(missing);
                            g.getMisaligned().addAll(misaligned);
                        });
                        missing.clear();
                        misaligned.clear();
                        break;
                    }
                    case "anyObject": {
                        Optional.ofNullable(anyObject).ifPresent(a -> {
                            a.getMissing().addAll(missing);
                            a.getMisaligned().addAll(misaligned);
                        });
                        missing.clear();
                        misaligned.clear();
                        break;
                    }
                    case "onSyncope": {
                        ((Misaligned)misaligned.get(misaligned.size() - 1)).getOnSyncope().addAll(onSyncope);
                        onSyncope = null;
                        break;
                    }
                    case "onResource": {
                        ((Misaligned)misaligned.get(misaligned.size() - 1)).getOnResource().addAll(onResource);
                        onResource = null;
                        break;
                    }
                }
            }
            streamReader.next();
        }
        return report;
    }

    private ReconciliationReportParser() {
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }
}

