/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.chartjs.Chart;
import org.apache.syncope.client.console.chartjs.ChartJSPanel;
import org.apache.syncope.client.console.chartjs.Line;
import org.apache.syncope.client.console.chartjs.LineChartData;
import org.apache.syncope.client.console.chartjs.LineDataSet;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LoadWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private final ChartJSPanel chart;

    public LoadWidget(String id, SystemInfo systeminfo) {
        super(id);
        this.setOutputMarkupId(true);
        this.chart = new ChartJSPanel("chart", (IModel<? extends Chart<?>>)Model.of((Serializable)LoadWidget.build(systeminfo)));
        this.add(new Component[]{this.chart});
    }

    private static Line build(SystemInfo systeminfo) {
        ArrayList cpuValues = new ArrayList();
        ArrayList memValues = new ArrayList();
        Line line = new Line();
        line.getOptions().setPointDot(false);
        line.getOptions().setDatasetFill(false);
        line.getOptions().setResponsive(true);
        line.getOptions().setMaintainAspectRatio(true);
        line.getOptions().setShowScale(false);
        line.getOptions().setMultiTooltipTemplate("<%= datasetLabel %>");
        systeminfo.getLoad().forEach(instant -> {
            ((LineChartData)line.getData()).getLabels().add(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(systeminfo.getStartTime() + instant.getUptime()));
            cpuValues.add(instant.getSystemLoadAverage() * 1000.0);
            memValues.add(instant.getTotalMemory());
        });
        LineDataSet cpuDataSet = new LineDataSet(cpuValues);
        cpuDataSet.setLabel("CPU");
        cpuDataSet.setPointColor("purple");
        cpuDataSet.setStrokeColor("purple");
        ((LineChartData)line.getData()).getDatasets().add(cpuDataSet);
        LineDataSet memDataSet = new LineDataSet(memValues);
        memDataSet.setLabel("MEM");
        memDataSet.setPointColor("grey");
        memDataSet.setStrokeColor("grey");
        ((LineChartData)line.getData()).getDatasets().add(memDataSet);
        return line;
    }

    public void refresh(SystemInfo systeminfo) {
        this.chart.setDefaultModelObject(LoadWidget.build(systeminfo));
    }
}

