/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmPolicyProvider;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmDetails
extends Panel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDetails.class);
    private final IModel<List<String>> logicActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return ImplementationRestClient.list("LOGIC_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    private final LoadableDetachableModel<List<String>> resources = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return SyncopeWebApplication.get().getResourceProvider().get();
        }
    };
    private final ActionsPanel<RealmTO> actionsPanel;
    @SpringBean
    private RealmPolicyProvider realmPolicyProvider;
    private final WebMarkupContainer container;

    public RealmDetails(String id, RealmTO realmTO) {
        this(id, realmTO, null, true);
    }

    public RealmDetails(String id, RealmTO realmTO, ActionsPanel<RealmTO> actionsPanel, boolean unwrapped) {
        super(id);
        this.actionsPanel = actionsPanel;
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.container.setRenderBodyOnly(unwrapped);
        this.add(new Component[]{this.container});
        WebMarkupContainer generics = new WebMarkupContainer("generics");
        this.container.add(new Component[]{generics.setVisible(unwrapped)});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)realmTO, "name"), false);
        name.addRequiredLabel();
        generics.add(new Component[]{name});
        AjaxTextFieldPanel fullPath = new AjaxTextFieldPanel("fullPath", "fullPath", (IModel)new PropertyModel((Object)realmTO, "fullPath"), false);
        fullPath.setEnabled(false);
        generics.add(new Component[]{fullPath});
        RepeatingView policies = new RepeatingView("policies");
        this.realmPolicyProvider.add(realmTO, policies);
        this.container.add(new Component[]{policies});
        AjaxPalettePanel actions = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actions", (IModel)new PropertyModel((Object)realmTO, "actions"), (IModel)new ListModel((List)this.logicActions.getObject()));
        actions.setOutputMarkupId(true);
        this.container.add(new Component[]{actions});
        this.container.add(new Component[]{new AjaxPalettePanel.Builder().build("resources", (IModel)new PropertyModel((Object)realmTO, "resources"), (IModel)new ListModel((List)this.resources.getObject())).setOutputMarkupId(true).setEnabled(!"/".equals(realmTO.getName())).setVisible(!"/".equals(realmTO.getName()))});
        if (actionsPanel == null) {
            this.add(new Component[]{new Fragment("actions", "emptyFragment", (MarkupContainer)this).setRenderBodyOnly(true)});
        } else {
            Fragment fragment = new Fragment("actions", "actionsFragment", (MarkupContainer)this);
            fragment.add(new Component[]{actionsPanel});
            this.add(new Component[]{fragment.setRenderBodyOnly(true)});
        }
    }

    public RealmDetails setContentEnabled(boolean enable) {
        this.container.setEnabled(enable);
        return this;
    }

    public ActionsPanel<RealmTO> getActionsPanel() {
        return this.actionsPanel;
    }
}

