/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.panels.ConfParam;
import org.apache.syncope.client.console.panels.ParametersWizardPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ParametersWizardAttrStep
extends WizardStep {
    private static final long serialVersionUID = -7843275202297616553L;
    private final AjaxTextFieldPanel schema;

    public ParametersWizardAttrStep(AjaxWizard.Mode mode, final ParametersWizardPanel.ParametersForm modelObject) {
        this.setOutputMarkupId(true);
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.add(new Component[]{content});
        this.schema = new AjaxTextFieldPanel("schema", this.getString("schema"), (IModel)new PropertyModel((Object)modelObject.getParam(), "schema"));
        this.schema.setRequired(true);
        this.schema.setReadOnly(mode != AjaxWizard.Mode.CREATE);
        content.add(new Component[]{this.schema});
        LoadableDetachableModel<List<PlainSchemaTO>> schemas = new LoadableDetachableModel<List<PlainSchemaTO>>(){
            private static final long serialVersionUID = 7172461137064525667L;

            protected List<PlainSchemaTO> load() {
                return List.of(modelObject.getSchema());
            }
        };
        ListView<PlainSchemaTO> attrs = new ListView<PlainSchemaTO>("attrs", (IModel)schemas){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<PlainSchemaTO> item) {
                item.add(new Component[]{ParametersWizardAttrStep.this.getFieldPanel("panel", modelObject.getParam(), (PlainSchemaTO)item.getModelObject())});
            }
        };
        content.add(new Component[]{attrs});
    }

    private Panel getFieldPanel(String id, ConfParam param, PlainSchemaTO plainSchemaTO) {
        Object panel;
        String valueHeaderName = this.getString("values");
        switch (plainSchemaTO.getType()) {
            case Date: {
                panel = new AjaxDateTimeFieldPanel(id, valueHeaderName, (IModel)new Model(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
                break;
            }
            case Boolean: {
                panel = new AjaxDropDownChoicePanel(id, valueHeaderName, (IModel)new Model(), false);
                ((AjaxDropDownChoicePanel)panel).setChoices(List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
                if (!param.getValues().isEmpty()) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<Boolean>(){
                        private static final long serialVersionUID = -8223314361351275865L;

                        public Object getDisplayValue(Boolean object) {
                            return BooleanUtils.toStringTrueFalse((Boolean)object);
                        }

                        public String getIdValue(Boolean object, int index) {
                            return BooleanUtils.toStringTrueFalse((Boolean)object);
                        }

                        public Boolean getObject(String id, IModel<? extends List<? extends Boolean>> choices) {
                            return BooleanUtils.toBoolean((String)id);
                        }
                    });
                }
                ((AjaxDropDownChoicePanel)panel).setNullValid(false);
                break;
            }
            case Long: {
                panel = new AjaxSpinnerFieldPanel.Builder().build(id, valueHeaderName, Long.class, (IModel)new Model());
                break;
            }
            case Double: {
                panel = new AjaxSpinnerFieldPanel.Builder().build(id, valueHeaderName, Double.class, (IModel)new Model());
                break;
            }
            case Binary: {
                panel = new BinaryFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), "application/octet-stream", (String)((Object)this.schema.getModelObject()));
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel(id, valueHeaderName, (IModel)new Model(), false);
            }
        }
        if (plainSchemaTO.isMultivalue()) {
            return new MultiFieldPanel.Builder(new PropertyModel((Object)param, "values")).build(id, valueHeaderName, panel);
        }
        panel.setNewModel(param.getValues());
        panel.setRequired("true".equalsIgnoreCase(plainSchemaTO.getMandatoryCondition()));
        return panel;
    }
}

