/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.RealmPolicyProvider;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class IdRepoRealmPolicyProvider
implements RealmPolicyProvider {
    private static final long serialVersionUID = 1L;
    private final IModel<Map<String, String>> accountPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list(PolicyType.ACCOUNT).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };
    private final IModel<Map<String, String>> passwordPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list(PolicyType.PASSWORD).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };

    @Override
    public void add(RealmTO realmTO, RepeatingView view) {
        AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel(view.newChildId(), new ResourceModel("accountPolicy", "accountPolicy").getObject(), (IModel)new PropertyModel((Object)realmTO, "accountPolicy"), false);
        accountPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(this.accountPolicies));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((AbstractSingleSelectChoice)accountPolicy.getField()).setNullValid(true);
        view.add(new Component[]{accountPolicy});
        AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel(view.newChildId(), new ResourceModel("passwordPolicy", "passwordPolicy").getObject(), (IModel)new PropertyModel((Object)realmTO, "passwordPolicy"), false);
        passwordPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(this.passwordPolicies));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((AbstractSingleSelectChoice)passwordPolicy.getField()).setNullValid(true);
        view.add(new Component[]{passwordPolicy});
    }
}

