/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import com.giffing.wicket.spring.boot.starter.app.WicketBootSecuredWebApplication;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.client.console.ConsoleProperties;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.AccessPolicyConfProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionLinksProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionsProvider;
import org.apache.syncope.client.console.commons.AnyWizardBuilderAdditionalSteps;
import org.apache.syncope.client.console.commons.ExternalResourceProvider;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.commons.PolicyTabProvider;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.commons.VirSchemaDetailsPanelProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.client.console.pages.MustChangePassword;
import org.apache.syncope.client.console.wizards.any.UserFormFinalizer;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.ui.commons.SyncopeUIRequestCycleListener;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.client.ui.commons.themes.AdminLTE;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.XForwardedRequestWrapperFactory;
import org.apache.wicket.protocol.ws.WebSocketAwareResourceIsolationRequestCycleListener;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ClassUtils;

public class SyncopeWebApplication
extends WicketBootSecuredWebApplication {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeWebApplication.class);
    protected final ConsoleProperties props;
    protected final ClassPathScanImplementationLookup lookup;
    protected final ServiceOps serviceOps;
    protected final ExternalResourceProvider resourceProvider;
    protected final AnyDirectoryPanelAdditionalActionsProvider anyDirectoryPanelAdditionalActionsProvider;
    protected final AnyDirectoryPanelAdditionalActionLinksProvider anyDirectoryPanelAdditionalActionLinksProvider;
    protected final AnyWizardBuilderAdditionalSteps anyWizardBuilderAdditionalSteps;
    protected final StatusProvider statusProvider;
    protected final VirSchemaDetailsPanelProvider virSchemaDetailsPanelProvider;
    protected final ImplementationInfoProvider implementationInfoProvider;
    protected final AccessPolicyConfProvider accessPolicyConfProvider;
    protected final ApplicationContext ctx;

    public static SyncopeWebApplication get() {
        return (SyncopeWebApplication)WebApplication.get();
    }

    public SyncopeWebApplication(ConsoleProperties props, ClassPathScanImplementationLookup lookup, ServiceOps serviceOps, ExternalResourceProvider resourceProvider, AnyDirectoryPanelAdditionalActionsProvider anyDirectoryPanelAdditionalActionsProvider, AnyDirectoryPanelAdditionalActionLinksProvider anyDirectoryPanelAdditionalActionLinksProvider, AnyWizardBuilderAdditionalSteps anyWizardBuilderAdditionalSteps, StatusProvider statusProvider, VirSchemaDetailsPanelProvider virSchemaDetailsPanelProvider, ImplementationInfoProvider implementationInfoProvider, AccessPolicyConfProvider accessPolicyConfProvider, ApplicationContext ctx) {
        this.props = props;
        this.lookup = lookup;
        this.serviceOps = serviceOps;
        this.resourceProvider = resourceProvider;
        this.anyDirectoryPanelAdditionalActionsProvider = anyDirectoryPanelAdditionalActionsProvider;
        this.anyDirectoryPanelAdditionalActionLinksProvider = anyDirectoryPanelAdditionalActionLinksProvider;
        this.anyWizardBuilderAdditionalSteps = anyWizardBuilderAdditionalSteps;
        this.statusProvider = statusProvider;
        this.virSchemaDetailsPanelProvider = virSchemaDetailsPanelProvider;
        this.implementationInfoProvider = implementationInfoProvider;
        this.accessPolicyConfProvider = accessPolicyConfProvider;
        this.ctx = ctx;
    }

    protected void init() {
        super.init();
        BootstrapSettings settings = new BootstrapSettings();
        settings.setThemeProvider((ThemeProvider)new SingleThemeProvider((ITheme)new AdminLTE()));
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getResourceSettings().setUseMinifiedResources(true);
        this.getResourceSettings().setUseDefaultOnMissingResource(true);
        this.getResourceSettings().setThrowExceptionOnMissingResource(false);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new MetaDataRoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.lookup.getIdRepoPageClasses().forEach(cls -> MetaDataRoleAuthorizationStrategy.authorize((Class)cls, (String)"AUTHENTICATED"));
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        this.getRequestCycleListeners().add((Object)new SyncopeUIRequestCycleListener(){

            protected boolean isSignedIn() {
                return SyncopeConsoleSession.get().isSignedIn();
            }

            protected void invalidateSession() {
                SyncopeConsoleSession.get().invalidate();
            }

            protected IRequestablePage getErrorPage(PageParameters errorParameters) {
                return new Login(errorParameters);
            }
        });
        if (this.props.isxForward()) {
            XForwardedRequestWrapperFactory.Config config = new XForwardedRequestWrapperFactory.Config();
            config.setProtocolHeader(this.props.getxForwardProtocolHeader());
            config.setHttpServerPort(this.props.getxForwardHttpPort());
            config.setHttpsServerPort(this.props.getxForwardHttpsPort());
            XForwardedRequestWrapperFactory factory = new XForwardedRequestWrapperFactory();
            factory.setConfig(config);
            this.getFilterFactoryManager().add((AbstractRequestWrapperFactory)factory);
        }
        if (this.props.isCsrf()) {
            this.getRequestCycleListeners().add((Object)new WebSocketAwareResourceIsolationRequestCycleListener());
        }
        this.getRequestCycleListeners().add((Object)new IRequestCycleListener(){

            public void onEndRequest(RequestCycle cycle) {
                if (cycle.getResponse() instanceof WebResponse && !(cycle.getResponse() instanceof WebSocketResponse)) {
                    SyncopeWebApplication.this.props.getSecurityHeaders().forEach((name, value) -> ((WebResponse)cycle.getResponse()).setHeader(name, value));
                }
            }
        });
        this.getCspSettings().blocking().unsafeInline();
        this.mountPage("/login", this.getSignInPageClass());
        for (Class<AbstractResource> resource : this.lookup.getClasses(AbstractResource.class)) {
            Resource annotation = resource.getAnnotation(Resource.class);
            try {
                final AbstractResource instance = resource.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LOG.debug("Mounting {} under {}", (Object)resource.getName(), (Object)annotation.path());
                this.mountResource(annotation.path(), new ResourceReference(annotation.key()){
                    protected static final long serialVersionUID = -128426276529456602L;

                    public IResource getResource() {
                        return instance;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Could not instantiate {}", (Object)resource.getName(), (Object)e);
            }
        }
        if (this.getDebugSettings().isAjaxDebugModeEnabled()) {
            this.getDebugSettings().setComponentPathAttributeName("syncope-path");
        }
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return SyncopeConsoleSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return Login.class;
    }

    public Class<? extends Page> getHomePage() {
        return AuthenticatedWebSession.get().isSignedIn() && SyncopeConsoleSession.get().getSelfTO().isMustChangePassword() ? MustChangePassword.class : Dashboard.class;
    }

    public ClassPathScanImplementationLookup getLookup() {
        return this.lookup;
    }

    public Class<? extends BasePage> getPageClass(String name) {
        return this.props.getPage().get(name);
    }

    public ThreadPoolTaskExecutor newThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setWaitForTasksToCompleteOnShutdown(false);
        executor.setCorePoolSize(this.props.getTopology().getCorePoolSize());
        executor.setMaxPoolSize(this.props.getTopology().getMaxPoolSize());
        executor.setQueueCapacity(this.props.getTopology().getQueueCapacity());
        executor.initialize();
        return executor;
    }

    public SyncopeClient newAnonymousClient() {
        return this.newClientFactory().create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.props.getAnonymousUser(), this.props.getAnonymousKey()));
    }

    public SyncopeClientFactoryBean newClientFactory() {
        return new SyncopeClientFactoryBean().setAddress(this.serviceOps.get(NetworkService.Type.CORE).getAddress()).setUseCompression(this.props.isUseGZIPCompression());
    }

    public String getDefaultAnyPanelClass() {
        return this.props.getDefaultAnyPanelClass();
    }

    public String getAdminUser() {
        return this.props.getAdminUser();
    }

    public String getAnonymousUser() {
        return this.props.getAnonymousUser();
    }

    public String getAnonymousKey() {
        return this.props.getAnonymousKey();
    }

    public String getReconciliationReportKey() {
        return this.props.getReconciliationReportKey();
    }

    public long getMaxWaitTimeInSeconds() {
        return this.props.getMaxWaitTimeOnApplyChanges();
    }

    public int getMaxUploadFileSizeMB() {
        return this.props.getMaxUploadFileSizeMB();
    }

    public ExternalResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public AnyDirectoryPanelAdditionalActionsProvider getAnyDirectoryPanelAdditionalActionsProvider() {
        return this.anyDirectoryPanelAdditionalActionsProvider;
    }

    public AnyDirectoryPanelAdditionalActionLinksProvider getAnyDirectoryPanelAdditionalActionLinksProvider() {
        return this.anyDirectoryPanelAdditionalActionLinksProvider;
    }

    public AnyWizardBuilderAdditionalSteps getAnyWizardBuilderAdditionalSteps() {
        return this.anyWizardBuilderAdditionalSteps;
    }

    public StatusProvider getStatusProvider() {
        return this.statusProvider;
    }

    public VirSchemaDetailsPanelProvider getVirSchemaDetailsPanelProvider() {
        return this.virSchemaDetailsPanelProvider;
    }

    public ImplementationInfoProvider getImplementationInfoProvider() {
        return this.implementationInfoProvider;
    }

    public Collection<PolicyTabProvider> getPolicyTabProviders() {
        return this.ctx.getBeansOfType(PolicyTabProvider.class).values();
    }

    public List<UserFormFinalizer> getFormFinalizers(AjaxWizard.Mode mode) {
        ArrayList<UserFormFinalizer> finalizers = new ArrayList<UserFormFinalizer>();
        this.lookup.getUserFormFinalizerClasses(mode).forEach(finalizer -> {
            if (finalizer != null) {
                try {
                    finalizers.add((UserFormFinalizer)ClassUtils.getConstructorIfAvailable((Class)finalizer, (Class[])new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    LOG.error("Could not instantiate {}", finalizer, (Object)e);
                }
            }
        });
        return finalizers;
    }

    public AccessPolicyConfProvider getAccessPolicyConfProvider() {
        return this.accessPolicyConfProvider;
    }
}

