/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import java.util.Map;
import org.apache.syncope.client.console.ConsoleProperties;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.actuate.SyncopeConsoleInfoContributor;
import org.apache.syncope.client.console.commons.AccessPolicyConfProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionLinksProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionsProvider;
import org.apache.syncope.client.console.commons.AnyWizardBuilderAdditionalSteps;
import org.apache.syncope.client.console.commons.ExternalResourceProvider;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.commons.VirSchemaDetailsPanelProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.ui.commons.actuate.SyncopeCoreHealthIndicator;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(exclude={ErrorMvcAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class}, proxyBeanMethods=false)
@EnableConfigurationProperties(value={ConsoleProperties.class})
public class SyncopeConsoleApplication
extends SpringBootServletInitializer {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeConsoleApplication.class}).properties(new String[]{"spring.config.name:console"}).build().run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.properties(Map.of("wicket.external.websocket.registerServerEndpoint.enabled", false, "spring.config.name", "console")).sources(new Class[]{SyncopeConsoleApplication.class});
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeWebApplication syncopeWebApplication(ConsoleProperties props, ClassPathScanImplementationLookup lookup, ServiceOps serviceOps, ExternalResourceProvider resourceProvider, AnyDirectoryPanelAdditionalActionsProvider anyDirectoryPanelAdditionalActionsProvider, AnyDirectoryPanelAdditionalActionLinksProvider anyDirectoryPanelAdditionalActionLinksProvider, AnyWizardBuilderAdditionalSteps anyWizardBuilderAdditionalSteps, StatusProvider statusProvider, VirSchemaDetailsPanelProvider virSchemaDetailsPanelProvider, ImplementationInfoProvider implementationInfoProvider, AccessPolicyConfProvider accessPolicyConfProvider, ApplicationContext ctx) {
        return new SyncopeWebApplication(props, lookup, serviceOps, resourceProvider, anyDirectoryPanelAdditionalActionsProvider, anyDirectoryPanelAdditionalActionLinksProvider, anyWizardBuilderAdditionalSteps, statusProvider, virSchemaDetailsPanelProvider, implementationInfoProvider, accessPolicyConfProvider, ctx);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreHealthIndicator syncopeCoreHealthIndicator(ServiceOps serviceOps, ConsoleProperties props) {
        return new SyncopeCoreHealthIndicator(serviceOps, props.getAnonymousUser(), props.getAnonymousKey(), props.isUseGZIPCompression());
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeConsoleInfoContributor syncopeConsoleInfoContributor() {
        return new SyncopeConsoleInfoContributor();
    }

    @Bean
    public KeymasterStart keymasterStart() {
        return new KeymasterStart(NetworkService.Type.CONSOLE);
    }

    @Bean
    public KeymasterStop keymasterStop() {
        return new KeymasterStop(NetworkService.Type.CONSOLE);
    }
}

