/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.rest.api.service.BpmnProcessService;

public class BpmnProcessRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 5049285686167071017L;

    public static List<BpmnProcess> getDefinitions() {
        return ((BpmnProcessService)BpmnProcessRestClient.getService(BpmnProcessService.class)).list();
    }

    private static BpmnProcessService getService(MediaType mediaType) {
        BpmnProcessService service = (BpmnProcessService)BpmnProcessRestClient.getService(BpmnProcessService.class);
        MetadataMap headers = new MetadataMap();
        headers.put((Object)"Content-Type", List.of(mediaType.toString()));
        headers.put((Object)"Accept", List.of(mediaType.toString()));
        WebClient.client((Object)service).headers((MultivaluedMap)headers);
        return service;
    }

    public static InputStream getDefinition(MediaType mediaType, String key) {
        Response response = BpmnProcessRestClient.getService(mediaType).get(key);
        SyncopeConsoleSession.get().resetClient(BpmnProcessService.class);
        return (InputStream)response.getEntity();
    }

    public static void setDefinition(MediaType mediaType, String key, String definition) {
        BpmnProcessRestClient.getService(mediaType).set(key, definition);
        SyncopeConsoleSession.get().resetClient(BpmnProcessService.class);
    }

    public static byte[] getDiagram(String key) {
        byte[] diagram;
        BpmnProcessService service = (BpmnProcessService)BpmnProcessRestClient.getService(BpmnProcessService.class);
        WebClient.client((Object)service).accept(new String[]{"image/png"});
        Response response = service.exportDiagram(key);
        try {
            diagram = IOUtils.readBytesFromStream((InputStream)((InputStream)response.getEntity()));
        }
        catch (Exception e) {
            LOG.error("Could not get workflow diagram", (Throwable)e);
            diagram = new byte[]{};
        }
        return diagram;
    }

    public static void deleteDefinition(String key) {
        ((BpmnProcessService)BpmnProcessRestClient.getService(BpmnProcessService.class)).delete(key);
    }
}

