/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.VariableListenerEventDefinitionParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.alfresco.AlfrescoStartEvent;

public class StartEventXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public StartEventXMLConverter() {
        VariableListenerEventDefinitionParser variableListenerEventDefinitionParser = new VariableListenerEventDefinitionParser();
        this.childParserMap.put(variableListenerEventDefinitionParser.getElementName(), variableListenerEventDefinitionParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return StartEvent.class;
    }

    @Override
    protected String getXMLElementName() {
        return "startEvent";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String formKey = BpmnXMLUtil.getAttributeValue("formKey", xtr);
        StartEvent startEvent = null;
        if (StringUtils.isNotEmpty((CharSequence)formKey) && model.getStartEventFormTypes() != null && model.getStartEventFormTypes().contains(formKey)) {
            startEvent = new AlfrescoStartEvent();
        }
        if (startEvent == null) {
            startEvent = new StartEvent();
        }
        BpmnXMLUtil.addXMLLocation(startEvent, xtr);
        String elementId = xtr.getAttributeValue(null, "id");
        startEvent.setId(elementId);
        startEvent.setInitiator(BpmnXMLUtil.getAttributeValue("initiator", xtr));
        boolean interrupting = true;
        String interruptingAttribute = xtr.getAttributeValue(null, "isInterrupting");
        if ("false".equalsIgnoreCase(interruptingAttribute)) {
            interrupting = false;
        }
        startEvent.setInterrupting(interrupting);
        startEvent.setFormKey(formKey);
        String formValidation = BpmnXMLUtil.getAttributeValue("formFieldValidation", xtr);
        startEvent.setValidateFormFields(formValidation);
        String sameDeploymentAttribute = BpmnXMLUtil.getAttributeValue("sameDeployment", xtr);
        if ("false".equalsIgnoreCase(sameDeploymentAttribute)) {
            startEvent.setSameDeployment(false);
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)startEvent, this.childParserMap, model, xtr);
        return startEvent;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeQualifiedAttribute("initiator", startEvent.getInitiator(), xtw);
        this.writeQualifiedAttribute("formKey", startEvent.getFormKey(), xtw);
        this.writeQualifiedAttribute("formFieldValidation", startEvent.getValidateFormFields(), xtw);
        if (!startEvent.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "false", xtw);
        }
        if (startEvent.getEventDefinitions() != null && startEvent.getEventDefinitions().size() > 0) {
            this.writeDefaultAttribute("isInterrupting", String.valueOf(startEvent.isInterrupting()), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        didWriteExtensionStartElement = this.writeVariableListenerDefinition((Event)startEvent, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeFormProperties((FlowElement)startEvent, didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeEventDefinitions((Event)startEvent, startEvent.getEventDefinitions(), model, xtw);
    }
}

