/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.wa.starter.mapping.ClientAppMapper;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;

abstract class AbstractClientAppMapper
implements ClientAppMapper {
    AbstractClientAppMapper() {
    }

    protected void setCommon(BaseWebBasedRegisteredService service, ClientAppTO clientApp) {
        service.setId(clientApp.getClientAppId().longValue());
        service.setName(clientApp.getName());
        service.setDescription(clientApp.getDescription());
        if (!clientApp.getProperties().isEmpty()) {
            Map<String, RegisteredServiceProperty> properties = clientApp.getProperties().stream().collect(Collectors.toMap(Attr::getSchema, attr -> new DefaultRegisteredServiceProperty((Collection)attr.getValues()), (existing, replacement) -> existing));
            service.setProperties(properties);
        }
    }

    protected void setPolicies(BaseWebBasedRegisteredService service, RegisteredServiceAuthenticationPolicy authPolicy, RegisteredServiceMultifactorPolicy mfaPolicy, RegisteredServiceAccessStrategy accessStrategy, RegisteredServiceAttributeReleasePolicy attributeReleasePolicy) {
        if (authPolicy != null) {
            service.setAuthenticationPolicy(authPolicy);
        }
        if (mfaPolicy != null) {
            service.setMultifactorAuthenticationPolicy(mfaPolicy);
        }
        if (accessStrategy != null) {
            service.setAccessStrategy(accessStrategy);
        }
        if (attributeReleasePolicy != null) {
            service.setAttributeReleasePolicy(attributeReleasePolicy);
        }
    }
}

