/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class OAuth20DefaultAccessTokenFactory
implements OAuth20AccessTokenFactory {
    protected final UniqueTicketIdGenerator accessTokenIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicy;
    protected final JwtBuilder jwtBuilder;
    protected final ServicesManager servicesManager;

    public OAuth20DefaultAccessTokenFactory(ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicy, JwtBuilder jwtBuilder, ServicesManager servicesManager) {
        this((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy, jwtBuilder, servicesManager);
    }

    public OAuth20AccessToken create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, Collection<String> scopes, String token, String clientId, Map<String, Map<String, Object>> requestClaims, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.jwtBuilder.getServicesManager(), clientId);
        ExpirationPolicy expirationPolicyToUse = this.determineExpirationPolicyForService(registeredService);
        String accessTokenId = this.accessTokenIdGenerator.getNewTicketId("AT");
        OAuth20DefaultAccessToken at = new OAuth20DefaultAccessToken(accessTokenId, service, authentication, expirationPolicyToUse, ticketGrantingTicket, token, scopes, clientId, requestClaims, responseType, grantType);
        if (ticketGrantingTicket != null) {
            ticketGrantingTicket.getDescendantTickets().add(at.getId());
        }
        return at;
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20AccessToken.class;
    }

    protected ExpirationPolicy determineExpirationPolicyForService(OAuthRegisteredService registeredService) {
        if (registeredService != null && registeredService.getAccessTokenExpirationPolicy() != null) {
            RegisteredServiceOAuthAccessTokenExpirationPolicy policy = registeredService.getAccessTokenExpirationPolicy();
            String maxTime = policy.getMaxTimeToLive();
            String ttl = policy.getTimeToKill();
            if (StringUtils.isNotBlank((CharSequence)maxTime) && StringUtils.isNotBlank((CharSequence)ttl)) {
                return new OAuth20AccessTokenExpirationPolicy(Beans.newDuration((String)maxTime).getSeconds(), Beans.newDuration((String)ttl).getSeconds());
            }
        }
        return this.expirationPolicy.buildTicketExpirationPolicy();
    }

    @Generated
    public OAuth20DefaultAccessTokenFactory(UniqueTicketIdGenerator accessTokenIdGenerator, ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicy, JwtBuilder jwtBuilder, ServicesManager servicesManager) {
        this.accessTokenIdGenerator = accessTokenIdGenerator;
        this.expirationPolicy = expirationPolicy;
        this.jwtBuilder = jwtBuilder;
        this.servicesManager = servicesManager;
    }

    @Generated
    public UniqueTicketIdGenerator getAccessTokenIdGenerator() {
        return this.accessTokenIdGenerator;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20AccessToken> getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public JwtBuilder getJwtBuilder() {
        return this.jwtBuilder;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }
}

