/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.utils;

import java.util.Arrays;

public enum CipherAlgorithm {
    SHA("SHA-1"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA512("SHA-512"),
    SSHA("S-SHA-1"),
    SSHA1("S-SHA-1"),
    SSHA256("S-SHA-256"),
    SSHA512("S-SHA-512"),
    BCRYPT("BCRYPT");

    private final String algorithm;

    private CipherAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static CipherAlgorithm valueOfLabel(String label) {
        return Arrays.stream(CipherAlgorithm.values()).filter(item -> item.getAlgorithm().equals(label)).findFirst().orElse(null);
    }
}

