/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.wizards.any.AbstractAttrs;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.Attributable;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class PlainAttrs
extends AbstractAttrs<PlainSchemaTO> {
    private static final long serialVersionUID = 552437609667518888L;

    public <T extends AnyTO> PlainAttrs(AnyWrapper<T> modelObject, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichPlainAttrs) throws IllegalArgumentException {
        super(modelObject, mode, anyTypeClasses, whichPlainAttrs);
        if (modelObject.getInnerObject() instanceof UserTO) {
            this.fileKey = ((UserTO)UserTO.class.cast(modelObject.getInnerObject())).getUsername();
        } else if (modelObject.getInnerObject() instanceof GroupTO) {
            this.fileKey = ((GroupTO)GroupTO.class.cast(modelObject.getInnerObject())).getName();
        } else if (modelObject.getInnerObject() instanceof AnyObjectTO) {
            this.fileKey = ((AnyObjectTO)AnyObjectTO.class.cast(modelObject.getInnerObject())).getName();
        }
        this.previousObject = modelObject instanceof UserWrapper ? ((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO() : null;
        this.setTitleModel((IModel)new ResourceModel("attributes.plain"));
        this.add(new Component[]{new Accordion("plainSchemas", List.of(new AbstractTab((IModel)new ResourceModel("attributes.accordion", "Plain Attributes")){
            private static final long serialVersionUID = 1037272333056449378L;

            public WebMarkupContainer getPanel(String panelId) {
                return new PlainSchemasOwn(panelId, PlainAttrs.this.schemas, (IModel<List<Attr>>)PlainAttrs.this.attrs);
            }
        }), (IModel)Model.of((Serializable)Integer.valueOf(0))).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<MembershipTO>("membershipsPlainSchemas", this.memberships){
            private static final long serialVersionUID = 6741044372185745296L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("membershipPlainSchemas", List.of(new AbstractTab((IModel)new StringResourceModel("attributes.membership.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)membershipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemasMemberships(panelId, (Map)PlainAttrs.this.membershipSchemas.get(membershipTO.getGroupKey()), (IModel<Attributable>)new LoadableDetachableModel<Attributable>(){
                            private static final long serialVersionUID = 526768546610546553L;

                            protected Attributable load() {
                                return membershipTO;
                            }
                        });
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    @Override
    protected boolean reoderSchemas() {
        return super.reoderSchemas() && this.mode != AjaxWizard.Mode.TEMPLATE;
    }

    @Override
    protected List<Attr> getAttrsFromTO() {
        return this.anyTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected List<Attr> getAttrsFromTO(MembershipTO membershipTO) {
        return membershipTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected void setAttrs() {
        Map attrMap = EntityTOUtils.buildAttrMap((Collection)this.anyTO.getPlainAttrs());
        List attrs = this.schemas.values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attr.getValues().add("");
            } else {
                attr = (Attr)attrMap.get(schema.getKey());
            }
            return attr;
        }).collect(Collectors.toList());
        this.anyTO.getPlainAttrs().clear();
        this.anyTO.getPlainAttrs().addAll(attrs);
    }

    @Override
    protected void setAttrs(MembershipTO membershipTO) {
        HashMap attrMap = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).isPresent() ? EntityTOUtils.buildAttrMap((Collection)((MembershipTO)((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).get()).getPlainAttrs()) : new HashMap();
        List attrs = ((Map)this.membershipSchemas.get(membershipTO.getGroupKey())).values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attr.getValues().add("");
            } else {
                attr.getValues().addAll(((Attr)attrMap.get(schema.getKey())).getValues());
            }
            return attr;
        }).collect(Collectors.toList());
        membershipTO.getPlainAttrs().clear();
        membershipTO.getPlainAttrs().addAll(attrs);
    }

    protected class PlainSchemasMemberships
    extends AbstractAttrsWizardStep.PlainSchemas<Attributable> {
        private static final long serialVersionUID = 456754923340249215L;

        public PlainSchemasMemberships(String id, final Map<String, PlainSchemaTO> schemas, IModel<Attributable> attributableTO) {
            super(id);
            this.add(new Component[]{new ListView<Attr>("schemas", (IModel)new ListModel(((Attributable)attributableTO.getObject()).getPlainAttrs().stream().sorted(PlainAttrs.this.attrComparator).collect(Collectors.toList()))){
                private static final long serialVersionUID = 5306618783986001008L;

                protected void populateItem(ListItem<Attr> item) {
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(((Attr)item.getModelObject()).getSchema());
                    PlainSchemasMemberships.this.setPanel(schemas, item, schema == null ? false : schema.isReadonly());
                }
            }});
        }
    }

    protected class PlainSchemasOwn
    extends AbstractAttrsWizardStep.PlainSchemas<List<Attr>> {
        private static final long serialVersionUID = -4730563859116024676L;

        public PlainSchemasOwn(String id, final Map<String, PlainSchemaTO> schemas, IModel<List<Attr>> attrTOs) {
            super(id);
            this.add(new Component[]{new ListView<Attr>("schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<Attr> item) {
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(((Attr)item.getModelObject()).getSchema());
                    PlainSchemasOwn.this.setPanel(schemas, item, schema == null ? false : schema.isReadonly());
                }
            }});
        }
    }
}

