/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import org.apache.syncope.client.console.commons.TaskDataProvider;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public abstract class TaskDirectoryPanel<T extends TaskTO>
extends DirectoryPanel<T, T, TaskDataProvider<T>, TaskRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    protected final BaseModal<?> baseModal;
    protected final MultilevelPanel multiLevelPanelRef;

    protected TaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef, boolean wizardInModal) {
        this("first", baseModal, multiLevelPanelRef, pageRef, wizardInModal);
    }

    protected TaskDirectoryPanel(String id, PageReference pageRef) {
        this(id, null, null, pageRef, false);
    }

    protected TaskDirectoryPanel(String id, BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef, boolean wizardInModal) {
        super(id, pageRef, wizardInModal);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.restClient = new TaskRestClient();
        this.setShowResultPanel(false);
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<T, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.multiLevelPanelRef);
    }

    protected abstract void viewTaskExecs(T var1, AjaxRequestTarget var2);

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected static abstract class TasksProvider<T extends TaskTO>
    extends DirectoryDataProvider<T> {
        private static final long serialVersionUID = -20112718133295756L;
        private final TaskType id;

        public TasksProvider(int paginatorRows, TaskType id) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
            this.id = id;
        }

        public long size() {
            return TaskRestClient.count(this.id);
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }
}

