/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.CrontabPanel;
import org.apache.syncope.client.console.tasks.PushTaskFilters;
import org.apache.syncope.client.console.tasks.PushTaskWrapper;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class SchedTaskWizardBuilder<T extends SchedTaskTO>
extends BaseAjaxWizardBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final TaskType type;
    private PushTaskWrapper wrapper;
    private CrontabPanel crontabPanel;
    private final boolean isSearchEnabled;

    public SchedTaskWizardBuilder(TaskType type, T taskTO, PageReference pageRef) {
        super(taskTO, pageRef);
        this.type = type;
        this.isSearchEnabled = RealmsUtils.isSearchEnabled();
    }

    protected Serializable onApplyInternal(SchedTaskTO modelObject) {
        if (modelObject instanceof PushTaskTO && this.wrapper != null) {
            this.wrapper.fillFilterConditions();
        }
        modelObject.setCronExpression(this.crontabPanel.getCronExpression());
        if (modelObject.getKey() == null) {
            TaskRestClient.create(this.type, modelObject);
        } else {
            TaskRestClient.update(this.type, modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(SchedTaskTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        if (modelObject instanceof PushTaskTO) {
            this.wrapper = new PushTaskWrapper((PushTaskTO)PushTaskTO.class.cast(modelObject));
            wizardModel.add((IWizardStep)new PushTaskFilters(this.wrapper, this.pageRef));
        }
        wizardModel.add((IWizardStep)new Schedule(modelObject));
        return wizardModel;
    }

    private List<RealmTO> searchRealms(String realmQuery) {
        return this.isSearchEnabled ? RealmRestClient.search(RealmsUtils.buildQuery(realmQuery)).getResult() : RealmRestClient.list("/");
    }

    public class Schedule
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Schedule(SchedTaskTO taskTO) {
            SchedTaskWizardBuilder.this.crontabPanel = new CrontabPanel("schedule", (PropertyModel<String>)new PropertyModel((Object)taskTO, "cronExpression"), taskTO.getCronExpression());
            this.add(new Component[]{SchedTaskWizardBuilder.this.crontabPanel});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        private final IModel<List<String>> taskJobDelegates = SyncopeWebApplication.get().getImplementationInfoProvider().getTaskJobDelegates();
        private final IModel<List<String>> reconFilterBuilders = SyncopeWebApplication.get().getImplementationInfoProvider().getReconFilterBuilders();
        private final IModel<List<String>> pullActions = SyncopeWebApplication.get().getImplementationInfoProvider().getPullActions();
        private final IModel<List<String>> pushActions = SyncopeWebApplication.get().getImplementationInfoProvider().getPushActions();

        public Profile(SchedTaskTO taskTO) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)taskTO, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel)new PropertyModel((Object)taskTO, "description"), false);
            description.setEnabled(true);
            this.add(new Component[]{description});
            AjaxCheckBoxPanel active = new AjaxCheckBoxPanel("active", "active", (IModel)new PropertyModel((Object)taskTO, "active"), false);
            this.add(new Component[]{active});
            AjaxDropDownChoicePanel jobDelegate = new AjaxDropDownChoicePanel("jobDelegate", "jobDelegate", (IModel)new PropertyModel((Object)taskTO, "jobDelegate"), false);
            jobDelegate.setChoices((List)this.taskJobDelegates.getObject());
            jobDelegate.addRequiredLabel();
            jobDelegate.setEnabled(taskTO.getKey() == null);
            this.add(new Component[]{jobDelegate});
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(!SchedTaskWizardBuilder.this.isSearchEnabled);
            settings.setShowListOnEmptyInput(!SchedTaskWizardBuilder.this.isSearchEnabled);
            WebMarkupContainer macroTaskSpecifics = new WebMarkupContainer("macroTaskSpecifics");
            this.add(new Component[]{macroTaskSpecifics.setRenderBodyOnly(true)});
            AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("realm", "realm", (IModel)new PropertyModel((Object)taskTO, "realm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput(input) ? SchedTaskWizardBuilder.this.searchRealms(input).stream().map(RealmTO::getFullPath).collect(Collectors.toList()) : List.of()).iterator();
                }
            };
            if (taskTO instanceof MacroTaskTO) {
                realm.addRequiredLabel();
                if (StringUtils.isBlank((CharSequence)((MacroTaskTO)MacroTaskTO.class.cast(taskTO)).getRealm())) {
                    realm.setModelObject((Serializable)((Object)"/"));
                }
            }
            macroTaskSpecifics.add(new Component[]{realm});
            AjaxCheckBoxPanel continueOnError = new AjaxCheckBoxPanel("continueOnError", "continueOnError", (IModel)new PropertyModel((Object)taskTO, "continueOnError"), false);
            macroTaskSpecifics.add(new Component[]{continueOnError});
            AjaxCheckBoxPanel saveExecs = new AjaxCheckBoxPanel("saveExecs", "saveExecs", (IModel)new PropertyModel((Object)taskTO, "saveExecs"), false);
            macroTaskSpecifics.add(new Component[]{saveExecs});
            WebMarkupContainer pullTaskSpecifics = new WebMarkupContainer("pullTaskSpecifics");
            this.add(new Component[]{pullTaskSpecifics.setRenderBodyOnly(true)});
            boolean isFiltered = false;
            if (taskTO instanceof PullTaskTO) {
                isFiltered = ((PullTaskTO)PullTaskTO.class.cast(taskTO)).getPullMode() == PullMode.FILTERED_RECONCILIATION;
            } else {
                pullTaskSpecifics.setEnabled(false).setVisible(false);
            }
            final AjaxDropDownChoicePanel pullMode = new AjaxDropDownChoicePanel("pullMode", "pullMode", (IModel)new PropertyModel((Object)taskTO, "pullMode"), false);
            pullMode.setChoices(List.of(PullMode.values()));
            if (taskTO instanceof PullTaskTO) {
                pullMode.addRequiredLabel();
            }
            pullMode.setNullValid(!(taskTO instanceof PullTaskTO));
            pullTaskSpecifics.add(new Component[]{pullMode});
            final AjaxDropDownChoicePanel reconFilterBuilder = new AjaxDropDownChoicePanel("reconFilterBuilder", "reconFilterBuilder", (IModel)new PropertyModel((Object)taskTO, "reconFilterBuilder"), false);
            reconFilterBuilder.setChoices((List)this.reconFilterBuilders.getObject());
            reconFilterBuilder.setEnabled(isFiltered);
            reconFilterBuilder.setRequired(isFiltered);
            pullTaskSpecifics.add(new Component[]{reconFilterBuilder});
            pullMode.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    reconFilterBuilder.setEnabled(pullMode.getModelObject() == PullMode.FILTERED_RECONCILIATION);
                    reconFilterBuilder.setRequired(pullMode.getModelObject() == PullMode.FILTERED_RECONCILIATION);
                    target.add(new Component[]{reconFilterBuilder});
                }
            }});
            AjaxSearchFieldPanel destinationRealm = new AjaxSearchFieldPanel("destinationRealm", "destinationRealm", (IModel)new PropertyModel((Object)taskTO, "destinationRealm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput(input) ? SchedTaskWizardBuilder.this.searchRealms(input).stream().map(RealmTO::getFullPath).collect(Collectors.toList()) : List.of()).iterator();
                }
            };
            if (taskTO instanceof PullTaskTO) {
                destinationRealm.addRequiredLabel();
                if (StringUtils.isBlank((CharSequence)((PullTaskTO)PullTaskTO.class.cast(taskTO)).getDestinationRealm())) {
                    destinationRealm.setModelObject((Serializable)((Object)"/"));
                }
            }
            pullTaskSpecifics.add(new Component[]{destinationRealm});
            AjaxCheckBoxPanel remediation = new AjaxCheckBoxPanel("remediation", "remediation", (IModel)new PropertyModel((Object)taskTO, "remediation"), false);
            pullTaskSpecifics.add(new Component[]{remediation});
            WebMarkupContainer pushTaskSpecifics = new WebMarkupContainer("pushTaskSpecifics");
            this.add(new Component[]{pushTaskSpecifics.setRenderBodyOnly(true)});
            if (!(taskTO instanceof PushTaskTO)) {
                pushTaskSpecifics.setEnabled(false).setVisible(false);
            }
            AjaxSearchFieldPanel sourceRealm = new AjaxSearchFieldPanel("sourceRealm", "sourceRealm", (IModel)new PropertyModel((Object)taskTO, "sourceRealm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput(input) ? SchedTaskWizardBuilder.this.searchRealms(input).stream().map(RealmTO::getFullPath).collect(Collectors.toList()) : List.of()).iterator();
                }
            };
            if (taskTO instanceof PushTaskTO) {
                sourceRealm.addRequiredLabel();
            }
            pushTaskSpecifics.add(new Component[]{sourceRealm});
            WebMarkupContainer provisioningTaskSpecifics = new WebMarkupContainer("provisioningTaskSpecifics");
            this.add(new Component[]{provisioningTaskSpecifics.setRenderBodyOnly(true)});
            if (taskTO instanceof ProvisioningTaskTO) {
                jobDelegate.setEnabled(false).setVisible(false);
                macroTaskSpecifics.setEnabled(false).setVisible(false);
            } else if (taskTO instanceof MacroTaskTO) {
                jobDelegate.setEnabled(false).setVisible(false);
                provisioningTaskSpecifics.setEnabled(false).setVisible(false);
            } else {
                provisioningTaskSpecifics.setEnabled(false).setVisible(false);
                macroTaskSpecifics.setEnabled(false).setVisible(false);
            }
            AjaxPalettePanel actions = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actions", (IModel)new PropertyModel((Object)taskTO, "actions"), (IModel)new ListModel(taskTO instanceof PushTaskTO ? (List)this.pushActions.getObject() : (List)this.pullActions.getObject()));
            actions.setOutputMarkupId(true);
            provisioningTaskSpecifics.add(new Component[]{actions});
            AjaxDropDownChoicePanel matchingRule = new AjaxDropDownChoicePanel("matchingRule", "matchingRule", (IModel)new PropertyModel((Object)taskTO, "matchingRule"), false);
            matchingRule.setChoices(List.of(MatchingRule.values()));
            provisioningTaskSpecifics.add(new Component[]{matchingRule});
            AjaxDropDownChoicePanel unmatchingRule = new AjaxDropDownChoicePanel("unmatchingRule", "unmatchingRule", (IModel)new PropertyModel((Object)taskTO, "unmatchingRule"), false);
            unmatchingRule.setChoices(List.of(UnmatchingRule.values()));
            provisioningTaskSpecifics.add(new Component[]{unmatchingRule});
            AjaxCheckBoxPanel performCreate = new AjaxCheckBoxPanel("performCreate", "performCreate", (IModel)new PropertyModel((Object)taskTO, "performCreate"), false);
            provisioningTaskSpecifics.add(new Component[]{performCreate});
            AjaxCheckBoxPanel performUpdate = new AjaxCheckBoxPanel("performUpdate", "performUpdate", (IModel)new PropertyModel((Object)taskTO, "performUpdate"), false);
            provisioningTaskSpecifics.add(new Component[]{performUpdate});
            AjaxCheckBoxPanel performDelete = new AjaxCheckBoxPanel("performDelete", "performDelete", (IModel)new PropertyModel((Object)taskTO, "performDelete"), false);
            provisioningTaskSpecifics.add(new Component[]{performDelete});
            AjaxCheckBoxPanel syncStatus = new AjaxCheckBoxPanel("syncStatus", "syncStatus", (IModel)new PropertyModel((Object)taskTO, "syncStatus"), false);
            provisioningTaskSpecifics.add(new Component[]{syncStatus});
        }
    }
}

