/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.TaskDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.TaskDirectoryPanel;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CollectionPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class NotificationTaskDirectoryPanel
extends TaskDirectoryPanel<NotificationTaskTO>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    private final String notification;
    private final AnyTypeKind anyTypeKind;
    private final String entityKey;

    protected NotificationTaskDirectoryPanel(String notification, AnyTypeKind anyTypeKind, String entityKey, MultilevelPanel multiLevelPanelRef, PageReference pageRef) {
        super(null, multiLevelPanelRef, pageRef, false);
        this.notification = notification;
        this.anyTypeKind = anyTypeKind;
        this.entityKey = entityKey;
        this.initResultTable();
    }

    protected abstract void viewMailBody(MailTemplateFormat var1, String var2, AjaxRequestTarget var3);

    @Override
    protected List<IColumn<NotificationTaskTO, String>> getColumns() {
        ArrayList<IColumn<NotificationTaskTO, String>> columns = new ArrayList<IColumn<NotificationTaskTO, String>>();
        columns.add((IColumn<NotificationTaskTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<NotificationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("sender", (Component)this), (Object)"sender", "sender"));
        columns.add((IColumn<NotificationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("subject", (Component)this), (Object)"subject", "subject"));
        columns.add((IColumn<NotificationTaskTO, String>)new CollectionPropertyColumn((IModel<String>)new StringResourceModel("recipients", (Component)this), "recipients"));
        columns.add((IColumn<NotificationTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("start", (Component)this), "start", "start"));
        columns.add((IColumn<NotificationTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("end", (Component)this), "end", "end"));
        columns.add((IColumn<NotificationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this), (Object)"latestExecStatus", "latestExecStatus"));
        return columns;
    }

    @Override
    public ActionsPanel<NotificationTaskTO> getActions(IModel<NotificationTaskTO> model) {
        ActionsPanel<NotificationTaskTO> panel = super.getActions(model);
        final NotificationTaskTO taskTO = (NotificationTaskTO)model.getObject();
        panel.add(new ActionLink<NotificationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTaskTO modelObject) {
                NotificationTaskDirectoryPanel.this.viewTaskExecs(taskTO, target);
            }
        }, ActionLink.ActionType.VIEW, "TASK_READ");
        panel.add(new ActionLink<NotificationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTaskTO modelObject) {
                NotificationTaskDirectoryPanel.this.viewMailBody(MailTemplateFormat.TEXT, taskTO.getTextBody(), target);
            }
        }, ActionLink.ActionType.TEXT, "TASK_READ");
        panel.add(new ActionLink<NotificationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTaskTO modelObject) {
                NotificationTaskDirectoryPanel.this.viewMailBody(MailTemplateFormat.HTML, taskTO.getHtmlBody(), target);
            }
        }, ActionLink.ActionType.HTML, "TASK_READ");
        panel.add(new ActionLink<NotificationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTaskTO modelObject) {
                try {
                    ((TaskRestClient)NotificationTaskDirectoryPanel.this.restClient).startExecution(taskTO.getKey(), null);
                    SyncopeConsoleSession.get().success((Serializable)((Object)NotificationTaskDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{NotificationTaskDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While running {}", (Object)taskTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)NotificationTaskDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.EXECUTE, "TASK_EXECUTE");
        panel.add(new ActionLink<NotificationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTaskTO modelObject) {
                try {
                    TaskRestClient.delete(TaskType.NOTIFICATION, taskTO.getKey());
                    NotificationTaskDirectoryPanel.this.updateResultTable(target);
                    SyncopeConsoleSession.get().success((Serializable)((Object)NotificationTaskDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{NotificationTaskDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)taskTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)NotificationTaskDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        batches.add(ActionLink.ActionType.EXECUTE);
        return batches;
    }

    @Override
    protected NotificationTasksProvider dataProvider() {
        return new NotificationTasksProvider(this.notification, this.anyTypeKind, this.entityKey, this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "notificationtasks.paginator.rows";
    }

    protected static class NotificationTasksProvider
    extends TaskDataProvider<NotificationTaskTO> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final String notification;
        private final AnyTypeKind anyTypeKind;
        private final String entityKey;

        public NotificationTasksProvider(String notification, AnyTypeKind anyTypeKind, String entityKey, int paginatorRows) {
            super(paginatorRows, TaskType.NOTIFICATION);
            this.notification = notification;
            this.anyTypeKind = anyTypeKind;
            this.entityKey = entityKey;
        }

        public long size() {
            return TaskRestClient.count(this.anyTypeKind, this.entityKey, this.notification);
        }

        public Iterator<NotificationTaskTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return TaskRestClient.listNotificationTasks(this.notification, this.anyTypeKind, this.entityKey, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }
    }
}

