/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.rest.api.service.PolicyService;

public class PolicyRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -1392090291817187902L;
    private static final Comparator<PolicyTO> COMPARATOR = Comparator.comparing(PolicyTO::getName);

    public static <T extends PolicyTO> T read(PolicyType type, String key) {
        PolicyTO policy = null;
        try {
            policy = PolicyRestClient.getService(PolicyService.class).read(type, key);
        }
        catch (Exception e) {
            LOG.warn("No policy found for type {} and key {}", new Object[]{type, key, e});
        }
        return (T)policy;
    }

    public static <T extends PolicyTO> List<T> list(PolicyType type) {
        try {
            return PolicyRestClient.getService(PolicyService.class).list(type).stream().sorted(COMPARATOR).collect(Collectors.toList());
        }
        catch (Exception ignore) {
            LOG.debug("No policy found", (Throwable)ignore);
            return List.of();
        }
    }

    public static <T extends PolicyTO> void create(PolicyType type, T policy) {
        PolicyRestClient.getService(PolicyService.class).create(type, policy);
    }

    public static <T extends PolicyTO> void update(PolicyType type, T policy) {
        PolicyRestClient.getService(PolicyService.class).update(type, policy);
    }

    public static void delete(PolicyType type, String key) {
        PolicyRestClient.getService(PolicyService.class).delete(type, key);
    }
}

