/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.reports.ReportletWrapper;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class ReportletWizardBuilder
extends BaseAjaxWizardBuilder<ReportletWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private final LoadableDetachableModel<List<ImplementationTO>> reportlets = new LoadableDetachableModel<List<ImplementationTO>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<ImplementationTO> load() {
            return ImplementationRestClient.list("REPORTLET");
        }
    };
    private final String report;

    public ReportletWizardBuilder(String report, ReportletWrapper reportlet, PageReference pageRef) {
        super(reportlet, pageRef);
        this.report = report;
    }

    protected Serializable onApplyInternal(ReportletWrapper modelObject) {
        if (modelObject.getImplementationEngine() == ImplementationEngine.JAVA) {
            BeanWrapper confWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)modelObject.getConf());
            modelObject.getSCondWrapper().forEach((fieldName, pair) -> confWrapper.setPropertyValue(fieldName, (Object)SearchUtils.buildFIQL((List)pair.getRight(), (AbstractFiqlSearchConditionBuilder)pair.getLeft())));
            ((List)this.reportlets.getObject()).stream().filter(r -> r.getKey().equals(modelObject.getImplementationKey())).findFirst().ifPresent(reportlet -> {
                try {
                    reportlet.setBody(MAPPER.writeValueAsString((Object)modelObject.getConf()));
                    ImplementationRestClient.update(reportlet);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            });
        }
        ReportTO reportTO = ReportRestClient.read(this.report);
        if (modelObject.isNew()) {
            reportTO.getReportlets().add(modelObject.getImplementationKey());
        }
        ReportRestClient.update(reportTO);
        return modelObject;
    }

    protected WizardModel buildModelSteps(ReportletWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        return wizardModel;
    }

    public class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Configuration(final ReportletWrapper reportlet) {
            LoadableDetachableModel<Serializable> bean = new LoadableDetachableModel<Serializable>(){
                private static final long serialVersionUID = 2092144708018739371L;

                protected Serializable load() {
                    return reportlet.getConf();
                }
            };
            this.add(new Component[]{new BeanPanel("bean", bean, reportlet.getSCondWrapper(), ReportletWizardBuilder.this.pageRef, new String[]{"name", "reportlet"}).setRenderBodyOnly(true)});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        private final ReportletWrapper reportlet;

        public Profile(final ReportletWrapper reportlet) {
            this.reportlet = reportlet;
            final AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("reportlet", this.getString("reportlet"), (IModel)new PropertyModel((Object)reportlet, "implementationKey"));
            conf.setChoices(((List)ReportletWizardBuilder.this.reportlets.getObject()).stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList()));
            conf.addRequiredLabel();
            conf.setNullValid(false);
            conf.setEnabled(reportlet.isNew());
            conf.add(new Behavior[]{new AjaxEventBehavior("change"){
                private static final long serialVersionUID = -7133385027739964990L;

                protected void onEvent(AjaxRequestTarget target) {
                    ((List)ReportletWizardBuilder.this.reportlets.getObject()).stream().filter(r -> r.getKey().equals(conf.getModelObject())).findFirst().ifPresent(impl -> {
                        reportlet.setImplementationEngine(impl.getEngine());
                        if (impl.getEngine() == ImplementationEngine.JAVA) {
                            try {
                                reportlet.setConf((ReportletConf)MAPPER.readValue(impl.getBody(), ReportletConf.class));
                            }
                            catch (Exception e) {
                                LOG.error("During deserialization", (Throwable)e);
                            }
                        }
                    });
                }
            }});
            this.add(new Component[]{conf});
        }

        public void applyState() {
            if (this.reportlet.getImplementationEngine() == ImplementationEngine.GROOVY) {
                this.getWizardModel().finish();
            }
        }
    }
}

