/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.SyncopeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class NetworkServiceDirectoryPanel
extends DirectoryPanel<NetworkService, NetworkService, NetworkServiceProvider, SyncopeRestClient> {
    private static final long serialVersionUID = 1868839768348072635L;
    @SpringBean
    private ServiceOps serviceOps;
    private final NetworkService.Type type;

    public NetworkServiceDirectoryPanel(String id, NetworkService.Type type, PageReference pageRef) {
        super(id, pageRef, true);
        this.type = type;
        NetworkService service = new NetworkService();
        service.setType(type);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.modal.addSubmitButton();
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.setFooterVisibility(true);
        this.initResultTable();
    }

    @Override
    protected List<IColumn<NetworkService, String>> getColumns() {
        ArrayList<IColumn<NetworkService, String>> columns = new ArrayList<IColumn<NetworkService, String>>();
        columns.add((IColumn<NetworkService, String>)new PropertyColumn((IModel)new StringResourceModel("address", (Component)this), (Object)"address", "address"));
        return columns;
    }

    @Override
    protected ActionsPanel<NetworkService> getActions(IModel<NetworkService> model) {
        return super.getActions(model);
    }

    @Override
    protected NetworkServiceProvider dataProvider() {
        return new NetworkServiceProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "network.service.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected class NetworkServiceProvider
    extends DirectoryDataProvider<NetworkService> {
        private static final long serialVersionUID = 8594921866993979224L;

        public NetworkServiceProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("address", SortOrder.ASCENDING);
        }

        public Iterator<NetworkService> iterator(long first, long count) {
            List list = NetworkServiceDirectoryPanel.this.serviceOps.list(NetworkServiceDirectoryPanel.this.type);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return NetworkServiceDirectoryPanel.this.serviceOps.list(NetworkServiceDirectoryPanel.this.type).size();
        }

        public IModel<NetworkService> model(final NetworkService service) {
            return new IModel<NetworkService>(){
                private static final long serialVersionUID = 999513782683391483L;

                public NetworkService getObject() {
                    return service;
                }
            };
        }
    }
}

