/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.MapOfListModel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.DynRealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.DynRealmWrapper;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class DynRealmModalPanel
extends AbstractModalPanel<DynRealmWrapper> {
    private static final long serialVersionUID = -3773196441177699452L;
    private final DynRealmWrapper dynRealmWrapper;
    private final boolean create;

    public DynRealmModalPanel(final DynRealmWrapper dynRealmWrapper, boolean create, BaseModal<DynRealmWrapper> modal, final PageReference pageRef) {
        super(modal, pageRef);
        this.dynRealmWrapper = dynRealmWrapper;
        this.create = create;
        modal.setFormModel(dynRealmWrapper);
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)dynRealmWrapper.getInnerObject(), "key"), false);
        key.setReadOnly(!create);
        key.setRequired(true);
        this.add(new Component[]{key});
        LoadableDetachableModel<List<AnyTypeTO>> types = new LoadableDetachableModel<List<AnyTypeTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<AnyTypeTO> load() {
                return AnyTypeRestClient.listAnyTypes();
            }
        };
        this.add(new Component[]{new ListView<AnyTypeTO>("dynMembershipCond", (IModel)types){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(final ListItem<AnyTypeTO> item) {
                final String key = ((AnyTypeTO)item.getModelObject()).getKey();
                item.add(new Component[]{new Accordion("dynMembershipCond", List.of(new AbstractTab((IModel)Model.of((Serializable)((Object)(key + " Dynamic Condition")))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public Panel getPanel(String panelId) {
                        switch (((AnyTypeTO)item.getModelObject()).getKind()) {
                            case USER: {
                                return new UserSearchPanel.Builder((IModel<List<SearchClause>>)new MapOfListModel(dynRealmWrapper, "dynClauses", key), pageRef).required(false).build(panelId);
                            }
                            case GROUP: {
                                return new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new MapOfListModel(dynRealmWrapper, "dynClauses", key), pageRef).required(false).build(panelId);
                            }
                        }
                        return new AnyObjectSearchPanel.Builder(key, (IModel<List<SearchClause>>)new MapOfListModel(dynRealmWrapper, "dynClauses", key), pageRef).required(false).build(panelId);
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(StringUtils.isBlank((CharSequence)dynRealmWrapper.getDynMembershipConds().get(key)) ? -1 : 0))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    public DynRealmWrapper getItem() {
        return this.dynRealmWrapper;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.dynRealmWrapper.fillDynamicConditions();
            if (this.create) {
                DynRealmRestClient.create(this.dynRealmWrapper.getInnerObject());
            } else {
                DynRealmRestClient.update(this.dynRealmWrapper.getInnerObject());
            }
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating/updating dynamic realm", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

