/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGridFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.Schema;
import org.apache.syncope.common.lib.report.SearchCondition;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class BeanPanel<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 3905038169553185171L;
    protected static final Logger LOG = LoggerFactory.getLogger(BeanPanel.class);
    private final List<String> excluded;
    private final Map<String, Pair<AbstractFiqlSearchConditionBuilder<?, ?, ?>, List<SearchClause>>> sCondWrapper;

    public BeanPanel(String id, IModel<T> bean, PageReference pageRef, String ... excluded) {
        this(id, bean, null, pageRef, excluded);
    }

    public BeanPanel(String id, final IModel<T> bean, Map<String, Pair<AbstractFiqlSearchConditionBuilder<?, ?, ?>, List<SearchClause>>> sCondWrapper, final PageReference pageRef, String ... excluded) {
        super(id, bean);
        this.setOutputMarkupId(true);
        this.sCondWrapper = sCondWrapper;
        this.excluded = new ArrayList<String>(List.of(excluded));
        this.excluded.add("serialVersionUID");
        this.excluded.add("class");
        LoadableDetachableModel<List<String>> model = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                ArrayList<String> result = new ArrayList<String>();
                if (BeanPanel.this.getDefaultModelObject() != null) {
                    ReflectionUtils.doWithFields(BeanPanel.this.getDefaultModelObject().getClass(), field -> result.add(field.getName()), field -> !field.isSynthetic() && !BeanPanel.this.excluded.contains(field.getName()));
                }
                return result;
            }
        };
        this.add(new Component[]{new ListView<String>("propView", (IModel)model){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<String> item) {
                Object panel;
                String fieldName = (String)item.getModelObject();
                item.add(new Component[]{new Label("fieldName", (IModel)new ResourceModel(fieldName, fieldName))});
                Field field = ReflectionUtils.findField(((Serializable)bean.getObject()).getClass(), (String)fieldName);
                if (field == null) {
                    return;
                }
                SearchCondition scondAnnot = field.getAnnotation(SearchCondition.class);
                Schema schemaAnnot = field.getAnnotation(Schema.class);
                BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean.getObject());
                if (scondAnnot != null) {
                    UserFiqlSearchConditionBuilder builder;
                    String fiql = (String)wrapper.getPropertyValue(fieldName);
                    List<SearchClause> clauses = SearchUtils.getSearchClauses(fiql);
                    switch (scondAnnot.type()) {
                        case "USER": {
                            panel = new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses), pageRef).required(false).build("value");
                            builder = SyncopeClient.getUserSearchConditionBuilder();
                            break;
                        }
                        case "GROUP": {
                            panel = new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses), pageRef).required(false).build("value");
                            builder = SyncopeClient.getGroupSearchConditionBuilder();
                            break;
                        }
                        default: {
                            panel = new AnyObjectSearchPanel.Builder(scondAnnot.type(), (IModel<List<SearchClause>>)new ListModel(clauses), pageRef).required(false).build("value");
                            builder = SyncopeClient.getAnyObjectSearchConditionBuilder((String)scondAnnot.type());
                        }
                    }
                    if (BeanPanel.this.sCondWrapper != null) {
                        BeanPanel.this.sCondWrapper.put(fieldName, Pair.of((Object)builder, clauses));
                    }
                } else if (List.class.equals(field.getType())) {
                    Class listItemType;
                    Class clazz = listItemType = field.getGenericType() instanceof ParameterizedType ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : String.class;
                    if (listItemType.equals(String.class) && schemaAnnot != null) {
                        ArrayList choices = new ArrayList();
                        block13: for (SchemaType type : schemaAnnot.type()) {
                            switch (type) {
                                case PLAIN: {
                                    choices.addAll(SchemaRestClient.getSchemas(SchemaType.PLAIN, schemaAnnot.anyTypeKind()));
                                    continue block13;
                                }
                                case DERIVED: {
                                    choices.addAll(SchemaRestClient.getSchemas(SchemaType.DERIVED, schemaAnnot.anyTypeKind()));
                                    continue block13;
                                }
                                case VIRTUAL: {
                                    choices.addAll(SchemaRestClient.getSchemas(SchemaType.VIRTUAL, schemaAnnot.anyTypeKind()));
                                    continue block13;
                                }
                            }
                        }
                        panel = new AjaxPalettePanel.Builder().setName(fieldName).build("value", (IModel)new PropertyModel(bean.getObject(), fieldName), (IModel)new ListModel(choices.stream().map(SchemaTO::getKey).collect(Collectors.toList()))).hideLabel();
                    } else {
                        panel = listItemType.isEnum() ? new AjaxPalettePanel.Builder().setName(fieldName).build("value", (IModel)new PropertyModel(bean.getObject(), fieldName), (IModel)new ListModel(List.of(listItemType.getEnumConstants()))).hideLabel() : new MultiFieldPanel.Builder(new PropertyModel(bean.getObject(), fieldName)).build("value", fieldName, BeanPanel.buildSinglePanel((Serializable)bean.getObject(), listItemType, fieldName, "panel")).hideLabel();
                    }
                } else {
                    panel = Map.class.equals(field.getType()) ? new AjaxGridFieldPanel("value", fieldName, (IModel)new PropertyModel((Object)bean, fieldName)).hideLabel() : BeanPanel.buildSinglePanel((Serializable)bean.getObject(), field.getType(), fieldName, "value").hideLabel();
                }
                item.add(new Component[]{panel.setRenderBodyOnly(true)});
            }
        }.setReuseItems(true).setOutputMarkupId(true)});
    }

    private static FieldPanel buildSinglePanel(final Serializable bean, Class<?> type, final String fieldName, String id) {
        PropertyModel model = new PropertyModel((Object)bean, fieldName);
        Object result = ClassUtils.isAssignable(Boolean.class, type) ? new AjaxCheckBoxPanel(id, fieldName, (IModel)model) : (ClassUtils.isAssignable(Number.class, type) ? new AjaxSpinnerFieldPanel.Builder().build(id, fieldName, ClassUtils.resolvePrimitiveIfNecessary(type), (IModel)model) : (Date.class.equals(type) ? new AjaxDateTimeFieldPanel(id, fieldName, (IModel)model, DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT) : (OffsetDateTime.class.equals(type) ? new AjaxDateTimeFieldPanel(id, fieldName, (IModel)new DateOps.WrappedDateModel((IModel)model), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT) : (type.isEnum() ? new AjaxDropDownChoicePanel(id, fieldName, (IModel)model).setChoices(List.of(type.getEnumConstants())) : (Duration.class.equals(type) ? new AjaxTextFieldPanel(id, fieldName, (IModel)new IModel<String>(){
            private static final long serialVersionUID = 807008909842554829L;

            public String getObject() {
                return Optional.ofNullable(PropertyResolver.getValue((String)fieldName, (Object)bean)).map(Object::toString).orElse(null);
            }

            public void setObject(String object) {
                PropertyResolverConverter prc = new PropertyResolverConverter(SyncopeWebApplication.get().getConverterLocator(), SyncopeConsoleSession.get().getLocale());
                PropertyResolver.setValue((String)fieldName, (Object)bean, (Object)Duration.parse(object), (PropertyResolverConverter)prc);
            }
        }) : new AjaxTextFieldPanel(id, fieldName, (IModel)model))))));
        result.hideLabel();
        return result;
    }
}

